/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CherryPickClassLoader;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.WithClassLoaderTest")
public class WithClassLoaderTest
extends MultipleCacheManagersTest {
    private static final String BASE = WithClassLoaderTest.class.getName() + "$";
    private static final String CAR = BASE + "Car";
    private ClassLoader systemCl;

    @Override
    protected void createCacheManagers() throws Throwable {
        EmbeddedCacheManager cm0 = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault());
        cm0.getDefaultConfiguration().fluent().clustering().mode(Configuration.CacheMode.REPL_SYNC).storeAsBinary().build();
        this.cacheManagers.add(cm0);
        String[] notFound = new String[]{CAR};
        this.systemCl = Thread.currentThread().getContextClassLoader();
        CherryPickClassLoader cl = new CherryPickClassLoader(null, null, notFound, this.systemCl);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault((ClassLoader)cl));
        cm1.getDefaultConfiguration().fluent().clustering().mode(Configuration.CacheMode.REPL_SYNC).storeAsBinary().build();
        this.cacheManagers.add(cm1);
    }

    public void testReadingWithCorrectClassLoaderAfterReplication() {
        Car value;
        Cache cache1;
        block2: {
            Cache cache0 = this.cache(0);
            cache1 = this.cache(1);
            value = new Car().plateNumber("1234");
            cache0.put((Object)1, (Object)value);
            try {
                cache1.get((Object)1);
                AssertJUnit.fail((String)"Expected a ClassNotFoundException");
            }
            catch (CacheException e) {
                if (e.getCause() instanceof ClassNotFoundException) break block2;
                throw e;
            }
        }
        AssertJUnit.assertEquals((Object)value, (Object)cache1.getAdvancedCache().with(this.systemCl).get((Object)1));
    }

    public static class Car
    implements Serializable {
        String plateNumber;

        Car plateNumber(String s) {
            this.plateNumber = s;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Car car = (Car)o;
            return !(this.plateNumber != null ? !this.plateNumber.equals(car.plateNumber) : car.plateNumber != null);
        }

        public int hashCode() {
            return this.plateNumber != null ? this.plateNumber.hashCode() : 0;
        }
    }
}

