/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.config.InfinispanConfiguration;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.MinimalConfigurationParsingTest")
public class MinimalConfigurationParsingTest {
    public void testGlobalAndDefaultSection() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\">    <global />\n    <default>\n        <locking concurrencyLevel=\"10000\" isolationLevel=\"READ_COMMITTED\" />\n    </default>\n</infinispan>";
        this.testXml(xml);
    }

    public void testNoGlobalSection() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\">    <default>\n        <locking concurrencyLevel=\"10000\" isolationLevel=\"READ_COMMITTED\" />\n    </default>\n</infinispan>";
        this.testXml(xml);
    }

    public void testNoDefaultSection() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\">    <global />\n</infinispan>";
        this.testXml(xml);
    }

    public void testNoSections() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\"></infinispan>";
        this.testXml(xml);
    }

    public void testNoSchema() throws IOException {
        String xml = "<infinispan></infinispan>";
        this.testXml(xml);
    }

    private void testXml(String xml) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        InfinispanConfiguration ic = InfinispanConfiguration.newInfinispanConfiguration((InputStream)stream);
        assert (ic != null);
    }
}

