/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.Util;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.BaseCacheStoreFunctionalTest")
public abstract class BaseCacheStoreFunctionalTest
extends AbstractInfinispanTest {
    protected CacheStoreConfig csConfig;
    protected Set<String> cacheNames = new HashSet<String>();

    protected abstract CacheStoreConfig createCacheStoreConfig() throws Exception;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        try {
            this.csConfig = this.createCacheStoreConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoCachesSameCacheStore() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            CacheLoaderManagerConfig clmConfig = new CacheLoaderManagerConfig();
            clmConfig.addCacheLoader(new CacheLoaderConfig[]{this.csConfig});
            localCacheManager.getDefaultConfiguration().setCacheLoaderManagerConfig(clmConfig);
            localCacheManager.defineConfiguration("first", new Configuration());
            localCacheManager.defineConfiguration("second", new Configuration());
            this.cacheNames.add("first");
            this.cacheNames.add("second");
            Cache first = localCacheManager.getCache("first");
            Cache second = localCacheManager.getCache("second");
            assert (first.getConfiguration().getCacheLoaderManagerConfig().getCacheLoaderConfigs().size() == 1);
            assert (second.getConfiguration().getCacheLoaderManagerConfig().getCacheLoaderConfigs().size() == 1);
            first.start();
            second.start();
            first.put((Object)"key", (Object)"val");
            assert (first.get((Object)"key").equals("val"));
            assert (second.get((Object)"key") == null);
            second.put((Object)"key2", (Object)"val2");
            assert (second.get((Object)"key2").equals("val2"));
            assert (first.get((Object)"key2") == null);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreloadAndExpiry() {
        CacheLoaderManagerConfig cacheLoaders = new CacheLoaderManagerConfig();
        cacheLoaders.setPreload(Boolean.valueOf(true));
        cacheLoaders.addCacheLoaderConfig((CacheLoaderConfig)this.csConfig);
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration(false);
        cfg.setCacheLoaderManagerConfig(cacheLoaders);
        EmbeddedCacheManager local = TestCacheManagerFactory.createCacheManager(cfg);
        try {
            Cache cache = local.getCache();
            this.cacheNames.add(cache.getName());
            cache.start();
            assert (cache.getConfiguration().getCacheLoaderManagerConfig().isPreload().booleanValue());
            cache.put((Object)"k1", (Object)"v");
            cache.put((Object)"k2", (Object)"v", 111111L, TimeUnit.MILLISECONDS);
            cache.put((Object)"k3", (Object)"v", -1L, TimeUnit.MILLISECONDS, 222222L, TimeUnit.MILLISECONDS);
            cache.put((Object)"k4", (Object)"v", 333333L, TimeUnit.MILLISECONDS, 444444L, TimeUnit.MILLISECONDS);
            cache.stop();
            cache.start();
            this.assertCacheEntry(cache, "k1", "v", -1L, -1L);
            this.assertCacheEntry(cache, "k2", "v", 111111L, -1L);
            this.assertCacheEntry(cache, "k3", "v", -1L, 222222L);
            this.assertCacheEntry(cache, "k4", "v", 333333L, 444444L);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{local});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{local});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestoreAtomicMap(Method m) {
        CacheContainer localCacheContainer = this.getContainerWithCacheLoader();
        try {
            Cache cache = localCacheContainer.getCache();
            this.cacheNames.add(cache.getName());
            AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)cache, (Object)m.getName());
            map.put((Object)"a", (Object)"b");
            cache.evict((Object)m.getName());
            assert (AtomicMapLookup.getAtomicMap((Cache)cache, (Object)m.getName()).get((Object)"a").equals("b"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheContainer);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestoreTransactionalAtomicMap(Method m) throws Exception {
        CacheContainer localCacheContainer = this.getContainerWithCacheLoader();
        try {
            Cache cache = localCacheContainer.getCache();
            this.cacheNames.add(cache.getName());
            TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
            tm.begin();
            AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)cache, (Object)m.getName());
            map.put((Object)"a", (Object)"b");
            tm.commit();
            cache.evict((Object)m.getName());
            assert (AtomicMapLookup.getAtomicMap((Cache)cache, (Object)m.getName()).get((Object)"a").equals("b"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheContainer);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testByteArrayKey(Method m) {
        CacheContainer localCacheContainer = this.getContainerWithCacheLoader();
        try {
            Cache cache = localCacheContainer.getCache();
            cache.put((Object)new ByteArrayKey(m.getName().getBytes()), (Object)"hello");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheContainer);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheContainer);
    }

    private CacheContainer getContainerWithCacheLoader() {
        Configuration cfg = new Configuration();
        cfg.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        cfg.getCacheLoaderManagerConfig().addCacheLoaderConfig((CacheLoaderConfig)this.csConfig);
        return TestCacheManagerFactory.createCacheManager(cfg);
    }

    private void assertCacheEntry(Cache cache, String key, String value, long lifespanMillis, long maxIdleMillis) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get((Object)key);
        assert (ice != null) : "No such entry for key " + key;
        assert (Util.safeEquals((Object)ice.getValue(), (Object)value)) : ice.getValue() + " is not the same as " + value;
        assert (ice.getLifespan() == lifespanMillis) : "Lifespan " + ice.getLifespan() + " not the same as " + lifespanMillis;
        assert (ice.getMaxIdle() == maxIdleMillis) : "MaxIdle " + ice.getMaxIdle() + " not the same as " + maxIdleMillis;
        if (lifespanMillis > -1L) assert (ice.getCreated() > -1L) : "Lifespan is set but created time is not";
        if (maxIdleMillis > -1L) assert (ice.getLastUsed() > -1L) : "Max idle is set but last used is not";
    }
}

