/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import junit.framework.Assert;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.L1LockTest")
public class L1LockTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = L1LockTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        config.fluent().hash().numOwners(Integer.valueOf(1)).transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.createCluster(config, 2);
        this.waitForClusterToForm();
    }

    public void testConsistency() throws Exception {
        Object localKey = this.getKeyForCache(0);
        this.cache(0).put(localKey, (Object)"foo");
        this.assertNotLocked(localKey);
        Assert.assertEquals((Object)"foo", (Object)this.cache(0).get(localKey));
        this.assertNotLocked(localKey);
        this.log.trace((Object)"About to perform 2nd get...");
        Assert.assertEquals((Object)"foo", (Object)this.cache(1).get(localKey));
        this.assertNotLocked(localKey);
        this.cache(0).put(localKey, (Object)"foo2");
        this.assertNotLocked(localKey);
        Assert.assertEquals((Object)"foo2", (Object)this.cache(0).get(localKey));
        Assert.assertEquals((Object)"foo2", (Object)this.cache(1).get(localKey));
        this.cache(1).put(localKey, (Object)"foo3");
        Assert.assertEquals((Object)"foo3", (Object)this.cache(0).get(localKey));
        Assert.assertEquals((Object)"foo3", (Object)this.cache(1).get(localKey));
    }
}

