/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TerminatedCacheWhileInTxTest")
public class TerminatedCacheWhileInTxTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createLocalCacheManager(true);
    }

    public void testStopWhileInTx(Method m) throws Throwable {
        this.stopCacheCalls(m, false);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNotAllowCallsWhileStopping(Method m) throws Throwable {
        this.stopCacheCalls(m, true);
    }

    private void stopCacheCalls(final Method m, boolean withCallStoppingCache) throws Throwable {
        final Cache cache = this.cacheManager.getCache("cache-" + m.getName());
        ExecutorService executorService = Executors.newCachedThreadPool();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch latch = new CountDownLatch(1);
        final TransactionManager tm = TestingUtil.getTransactionManager(cache);
        Callable<Void> waitAfterModCallable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TerminatedCacheWhileInTxTest.this.log.debug((Object)"Wait for all executions paths to be ready to perform calls.");
                tm.begin();
                cache.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
                TerminatedCacheWhileInTxTest.this.log.debug((Object)"Cache modified, wait for cache to be stopped.");
                barrier.await();
                latch.await(10L, TimeUnit.SECONDS);
                tm.commit();
                return null;
            }
        };
        Future<Void> waitAfterModFuture = executorService.submit(waitAfterModCallable);
        barrier.await();
        Future<Void> callStoppingCacheFuture = null;
        if (withCallStoppingCache) {
            Callable<Void> callStoppingCache = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TerminatedCacheWhileInTxTest.this.log.debug((Object)"Wait very briefly and then make call.");
                    Thread.sleep(1000L);
                    cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
                    return null;
                }
            };
            callStoppingCacheFuture = executorService.submit(callStoppingCache);
        }
        cache.stop();
        latch.countDown();
        this.log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
        waitAfterModFuture.get();
        if (callStoppingCacheFuture != null) {
            try {
                callStoppingCacheFuture.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        executorService.shutdownNow();
    }
}

