/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.tika;

import java.io.IOException;
import javax.jcr.Binary;
import junit.framework.Assert;
import org.junit.Test;
import org.modeshape.extractor.tika.TikaMimeTypeDetector;
import org.modeshape.jcr.InMemoryTestBinary;

public class TikaMimeTypeDetectorTest {
    public static final String TXT_FILE = "modeshape.txt";
    public static final String PDF_FILE = "modeshape_gs.pdf";
    public static final String POSTSCRIPT_FILE = "modeshape.ps";
    public static final String WORD_FILE = "modeshape.doc";
    public static final String WORD_OPEN_XML_FILE = "modeshape.docx";
    private TikaMimeTypeDetector detector = new TikaMimeTypeDetector();

    @Test
    public void shouldDetectTextPlainMimeTypeWithoutName() throws Exception {
        Assert.assertEquals((String)"text/plain", (String)this.detector.mimeTypeOf(null, (Binary)this.binaryFromFile(TXT_FILE)));
    }

    @Test
    public void shouldDetectTextPlainMimeTypeWithName() throws Exception {
        Assert.assertEquals((String)"text/plain", (String)this.detector.mimeTypeOf(TXT_FILE, (Binary)this.binaryFromFile(TXT_FILE)));
    }

    @Test
    public void shouldDetectPdfMimeTypeWithoutName() throws Exception {
        Assert.assertEquals((String)"application/pdf", (String)this.detector.mimeTypeOf(null, (Binary)this.binaryFromFile(PDF_FILE)));
    }

    @Test
    public void shouldDetectPdfMimeTypeWithName() throws Exception {
        Assert.assertEquals((String)"application/pdf", (String)this.detector.mimeTypeOf(PDF_FILE, (Binary)this.binaryFromFile(PDF_FILE)));
    }

    @Test
    public void shouldDetectPostscriptWithoutName() throws Exception {
        Assert.assertEquals((String)"application/postscript", (String)this.detector.mimeTypeOf(null, (Binary)this.binaryFromFile(POSTSCRIPT_FILE)));
    }

    @Test
    public void shouldDetectPostscriptWithName() throws Exception {
        Assert.assertEquals((String)"application/postscript", (String)this.detector.mimeTypeOf(POSTSCRIPT_FILE, (Binary)this.binaryFromFile(POSTSCRIPT_FILE)));
    }

    @Test
    public void shouldDetectMsWordWithoutName() throws Exception {
        Assert.assertEquals((String)"application/msword", (String)this.detector.mimeTypeOf(null, (Binary)this.binaryFromFile(WORD_FILE)));
    }

    @Test
    public void shouldDetectMsWordWithName() throws Exception {
        Assert.assertEquals((String)"application/msword", (String)this.detector.mimeTypeOf(WORD_FILE, (Binary)this.binaryFromFile(WORD_FILE)));
    }

    @Test
    public void shouldDetectMsWordOpenXMLWithoutName() throws Exception {
        Assert.assertEquals((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)this.detector.mimeTypeOf(null, (Binary)this.binaryFromFile(WORD_OPEN_XML_FILE)));
    }

    @Test
    public void shouldDetectMsWordOpenXMLWithName() throws Exception {
        Assert.assertEquals((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)this.detector.mimeTypeOf(WORD_OPEN_XML_FILE, (Binary)this.binaryFromFile(WORD_OPEN_XML_FILE)));
    }

    @Test
    public void shouldDetectXSD() throws Exception {
        Assert.assertEquals((String)"application/xml", (String)this.detector.mimeTypeOf(null, (Binary)this.binaryFromFile("xsd_file.xsd")));
    }

    @Test
    public void shouldDetectMimeTypeEventIfNameIsWrong() throws Exception {
        Assert.assertEquals((String)"text/plain", (String)this.detector.mimeTypeOf(PDF_FILE, (Binary)this.binaryFromFile(TXT_FILE)));
    }

    private InMemoryTestBinary binaryFromFile(String filePath) throws IOException {
        return new InMemoryTestBinary(this.getClass().getClassLoader().getResourceAsStream(filePath));
    }
}

