/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.Base64;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;

@Immutable
@Deprecated
public class ItemHandler
extends AbstractHandler {
    protected static final String PRIMARY_TYPE_PROPERTY = "jcr:primaryType";
    protected static final String MIXIN_TYPES_PROPERTY = "jcr:mixinTypes";
    protected static final String PROPERTIES_HOLDER = "properties";
    protected static final String CHILD_NODE_HOLDER = "children";

    @Deprecated
    public String getItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String path, int depth) throws JSONException, UnauthorizedException, RepositoryException {
        Node item;
        assert (path != null);
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        if ("/".equals(path) || "".equals(path)) {
            item = session.getRootNode();
        } else {
            try {
                item = session.getItem(path);
            }
            catch (PathNotFoundException pnfe) {
                throw new NotFoundException(pnfe.getMessage(), (Throwable)pnfe);
            }
        }
        JSONObject jsonObject = item instanceof Node ? this.jsonFor(item, depth) : this.jsonFor((Property)item);
        return RestHelper.responseString(jsonObject, request);
    }

    private JSONObject jsonFor(Property property) throws JSONException, RepositoryException {
        boolean encoded = false;
        String valueObject = null;
        if (property.getDefinition().isMultiple()) {
            Value[] values;
            for (Value value : values = property.getValues()) {
                if (value.getType() != 2) continue;
                encoded = true;
                break;
            }
            ArrayList<String> list = new ArrayList<String>(values.length);
            if (encoded) {
                for (Value value : values) {
                    list.add(RestHelper.jsonEncodedStringFor(value));
                }
            } else {
                for (Value value : values) {
                    list.add(value.getString());
                }
            }
            valueObject = new JSONArray(list);
        } else {
            Value value = property.getValue();
            encoded = value.getType() == 2;
            valueObject = encoded ? RestHelper.jsonEncodedStringFor(value) : value.getString();
        }
        String propertyName = property.getName();
        if (encoded) {
            propertyName = propertyName + "/base64/";
        }
        JSONObject jsonProperty = new JSONObject();
        jsonProperty.put(propertyName, (Object)valueObject);
        return jsonProperty;
    }

    private JSONObject jsonFor(Node node, int toDepth) throws JSONException, RepositoryException {
        Node child;
        NodeIterator iter;
        JSONObject children;
        JSONObject jsonNode = new JSONObject();
        JSONObject properties = new JSONObject();
        PropertyIterator iter2 = node.getProperties();
        while (iter2.hasNext()) {
            Property prop = iter2.nextProperty();
            String propName = prop.getName();
            boolean encoded = false;
            if (prop.getDefinition().isMultiple()) {
                Value[] values;
                for (Value value : values = prop.getValues()) {
                    if (value.getType() != 2) continue;
                    encoded = true;
                    break;
                }
                if (encoded) {
                    propName = propName + "/base64/";
                }
                JSONArray array = new JSONArray();
                for (int i = 0; i < values.length; ++i) {
                    array.put((Object)(encoded ? RestHelper.jsonEncodedStringFor(values[i]) : values[i].getString()));
                }
                properties.put(propName, (Object)array);
                continue;
            }
            Value value = prop.getValue();
            boolean bl = encoded = value.getType() == 2;
            if (encoded) {
                propName = propName + "/base64/";
            }
            properties.put(propName, (Object)(encoded ? RestHelper.jsonEncodedStringFor(value) : value.getString()));
        }
        if (properties.length() > 0) {
            jsonNode.put(PROPERTIES_HOLDER, (Object)properties);
        }
        if (toDepth == 0) {
            children = new ArrayList();
            iter = node.getNodes();
            while (iter.hasNext()) {
                child = iter.nextNode();
                String name = child.getIndex() == 1 ? child.getName() : child.getName() + "[" + child.getIndex() + "]";
                children.add(name);
            }
            if (children.size() > 0) {
                jsonNode.put(CHILD_NODE_HOLDER, (Object)new JSONArray((Collection)children));
            }
        } else {
            children = new JSONObject();
            iter = node.getNodes();
            while (iter.hasNext()) {
                child = iter.nextNode();
                String name = child.getIndex() == 1 ? child.getName() : child.getName() + "[" + child.getIndex() + "]";
                children.put(name, (Object)this.jsonFor(child, toDepth - 1));
            }
            if (children.length() > 0) {
                jsonNode.put(CHILD_NODE_HOLDER, (Object)children);
            }
        }
        return jsonNode;
    }

    public Response postItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String path, boolean fullNodeInResponse, String requestContent) throws NotFoundException, UnauthorizedException, RepositoryException, JSONException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (path != null);
        JSONObject body = new JSONObject(requestContent);
        int lastSlashInd = path.lastIndexOf(47);
        String parentPath = lastSlashInd == -1 ? "/" : "/" + path.substring(0, lastSlashInd);
        String newNodeName = lastSlashInd == -1 ? path : path.substring(lastSlashInd + 1);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Node parentNode = (Node)session.getItem(parentPath);
        Node newNode = this.addNode(parentNode, newNodeName, body);
        session.save();
        if (fullNodeInResponse) {
            String json = this.jsonFor(newNode, -1).toString();
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)json).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)newNode.getPath()).build();
    }

    protected Node addNode(Node parentNode, String nodeName, JSONObject jsonNode) throws RepositoryException, JSONException {
        Node newNode;
        JSONObject properties = this.getProperties(jsonNode);
        if (properties.has(PRIMARY_TYPE_PROPERTY)) {
            String primaryType = properties.getString(PRIMARY_TYPE_PROPERTY);
            newNode = parentNode.addNode(nodeName, primaryType);
        } else {
            newNode = parentNode.addNode(nodeName);
        }
        Iterator iter = properties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (PRIMARY_TYPE_PROPERTY.equals(key)) continue;
            this.setPropertyOnNode(newNode, key, properties.get(key));
        }
        if (this.hasChildren(jsonNode)) {
            JSONObject children = this.getChildren(jsonNode);
            Iterator iter2 = children.keys();
            while (iter2.hasNext()) {
                String childName = (String)iter2.next();
                JSONObject child = children.getJSONObject(childName);
                this.addNode(newNode, childName, child);
            }
        }
        return newNode;
    }

    protected JSONObject getChildren(JSONObject jsonNode) throws JSONException {
        return jsonNode.getJSONObject(CHILD_NODE_HOLDER);
    }

    protected boolean hasChildren(JSONObject jsonNode) {
        return jsonNode.has(CHILD_NODE_HOLDER);
    }

    protected JSONObject getProperties(JSONObject jsonNode) throws JSONException {
        return jsonNode.has(PROPERTIES_HOLDER) ? jsonNode.getJSONObject(PROPERTIES_HOLDER) : new JSONObject();
    }

    private Value decodeValue(String encodedValue, ValueFactory valueFactory) throws RepositoryException {
        InputStream stream = null;
        try {
            byte[] binaryValue = Base64.decode((String)encodedValue);
            stream = new ByteArrayInputStream(binaryValue);
            Binary binary = valueFactory.createBinary(stream);
            Value value = valueFactory.createValue(binary);
            return value;
        }
        catch (IOException ioe) {
            throw new RepositoryException((Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    protected void setPropertyOnNode(Node node, String propName, Object value) throws RepositoryException, JSONException {
        Value[] values;
        boolean encoded = propName.endsWith("/base64/");
        if (encoded) {
            int newLength = propName.length() - "/base64/".length();
            propName = newLength > 0 ? propName.substring(0, newLength) : "";
        }
        ValueFactory valueFactory = node.getSession().getValueFactory();
        if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            values = new Value[jsonValues.length()];
            for (int i = 0; i < values.length; ++i) {
                String strValue = jsonValues.getString(i);
                values[i] = encoded ? this.decodeValue(strValue, valueFactory) : valueFactory.createValue(strValue);
            }
        } else {
            String strValue = (String)value;
            values = encoded ? new Value[]{this.decodeValue(strValue, valueFactory)} : new Value[]{valueFactory.createValue(strValue)};
        }
        if (propName.equals(MIXIN_TYPES_PROPERTY)) {
            HashSet<String> toBeMixins = new HashSet<String>();
            for (Value theValue : values) {
                toBeMixins.add(theValue.getString());
            }
            HashSet<String> asIsMixins = new HashSet<String>();
            for (NodeType nodeType : node.getMixinNodeTypes()) {
                asIsMixins.add(nodeType.getName());
            }
            HashSet mixinsToAdd = new HashSet(toBeMixins);
            mixinsToAdd.removeAll(asIsMixins);
            asIsMixins.removeAll(toBeMixins);
            for (String nodeType : mixinsToAdd) {
                node.addMixin(nodeType);
            }
            for (String nodeType : asIsMixins) {
                node.removeMixin(nodeType);
            }
        } else if (values.length == 1) {
            node.setProperty(propName, values[0]);
        } else {
            node.setProperty(propName, values);
        }
    }

    public void deleteItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String path) throws NotFoundException, UnauthorizedException, RepositoryException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (path != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        this.doDelete(path, session);
        session.save();
    }

    protected void doDelete(String path, Session session) throws RepositoryException {
        Item item;
        try {
            item = session.getItem(path);
        }
        catch (PathNotFoundException pnfe) {
            throw new NotFoundException(pnfe.getMessage(), (Throwable)pnfe);
        }
        item.remove();
    }

    public String putItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String path, String requestContent) throws UnauthorizedException, JSONException, RepositoryException, IOException {
        assert (path != null);
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Node item = null;
        if ("".equals(path) || "/".equals(path)) {
            item = session.getRootNode();
        } else {
            try {
                item = session.getItem(path);
            }
            catch (PathNotFoundException pnfe) {
                throw new NotFoundException(pnfe.getMessage(), (Throwable)pnfe);
            }
        }
        Item updatedItem = this.updateItem((Item)item, new JSONObject(requestContent));
        Node node = updatedItem instanceof Property ? updatedItem.getParent() : (Node)updatedItem;
        node.getSession().save();
        return this.jsonFor(node, 0).toString();
    }

    protected Item updateItem(Item item, JSONObject jsonItem) throws RepositoryException, JSONException {
        if (item instanceof Node) {
            return this.updateNode((Node)item, jsonItem);
        }
        return this.updateProperty((Property)item, jsonItem);
    }

    private Property updateProperty(Property property, JSONObject jsonItem) throws RepositoryException, JSONException {
        String propertyName = property.getName();
        String jsonPropertyName = jsonItem.has(propertyName) ? propertyName : propertyName + "/base64/";
        Node node = property.getParent();
        this.setPropertyOnNode(node, jsonPropertyName, jsonItem.get(jsonPropertyName));
        return property;
    }

    private Node updateNode(Node node, JSONObject jsonItem) throws RepositoryException, JSONException {
        VersionableChanges changes = new VersionableChanges(node.getSession());
        try {
            node = this.updateNode(node, jsonItem, changes);
            changes.checkin();
        }
        catch (RepositoryException e) {
            changes.abort();
            throw e;
        }
        catch (JSONException e) {
            changes.abort();
            throw e;
        }
        catch (RuntimeException e) {
            changes.abort();
            throw e;
        }
        return node;
    }

    protected Node updateNode(Node node, JSONObject jsonNode, VersionableChanges changes) throws RepositoryException, JSONException {
        JSONObject properties = jsonNode;
        if (jsonNode.has(PROPERTIES_HOLDER)) {
            properties = jsonNode.getJSONObject(PROPERTIES_HOLDER);
        }
        changes.checkout(node);
        Iterator iter = properties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (PRIMARY_TYPE_PROPERTY.equals(key) || CHILD_NODE_HOLDER.equals(key)) continue;
            this.setPropertyOnNode(node, key, properties.get(key));
        }
        if (this.hasChildren(jsonNode)) {
            Node parent = node;
            JSONObject children = this.getChildren(jsonNode);
            LinkedHashMap<String, Node> existingChildNames = new LinkedHashMap<String, Node>();
            NodeIterator childIter = parent.getNodes();
            while (childIter.hasNext()) {
                Node child = childIter.nextNode();
                existingChildNames.put(this.nameOf(child), child);
            }
            Iterator iter2 = children.keys();
            while (iter2.hasNext()) {
                String childName = (String)iter2.next();
                JSONObject child = children.getJSONObject(childName);
                if (parent.hasNode(childName)) {
                    Node childNode = parent.getNode(childName);
                    this.updateNode(childNode, child, changes);
                    existingChildNames.remove(this.nameOf(childNode));
                    continue;
                }
                this.addNode(parent, childName, child);
            }
            LinkedList childNodes = new LinkedList(existingChildNames.values());
            Collections.reverse(childNodes);
            while (!childNodes.isEmpty()) {
                Node child = (Node)childNodes.removeLast();
                child.remove();
            }
        }
        return node;
    }

    private String nameOf(Node node) throws RepositoryException {
        int index = node.getIndex();
        String childName = node.getName();
        return index == 1 ? childName : childName + "[" + index + "]";
    }

    protected static class VersionableChanges {
        private final Set<String> changedVersionableNodes = new HashSet<String>();
        private final Session session;
        private final VersionManager versionManager;

        protected VersionableChanges(Session session) throws RepositoryException {
            this.session = session;
            assert (this.session != null);
            this.versionManager = session.getWorkspace().getVersionManager();
        }

        public void checkout(Node node) throws RepositoryException {
            boolean versionable = node.isNodeType("mix:versionable");
            if (versionable) {
                String path = node.getPath();
                this.versionManager.checkout(path);
                this.changedVersionableNodes.add(path);
            }
        }

        public void checkin() throws RepositoryException {
            if (this.changedVersionableNodes.isEmpty()) {
                return;
            }
            this.session.save();
            RepositoryException first = null;
            for (String path : this.changedVersionableNodes) {
                try {
                    if (!this.versionManager.isCheckedOut(path)) continue;
                    this.versionManager.checkin(path);
                }
                catch (RepositoryException e) {
                    if (first != null) continue;
                    first = e;
                }
            }
            if (first != null) {
                throw first;
            }
        }

        public void abort() throws RepositoryException {
            if (this.changedVersionableNodes.isEmpty()) {
                return;
            }
            this.session.refresh(false);
            RepositoryException first = null;
            for (String path : this.changedVersionableNodes) {
                try {
                    if (!this.versionManager.isCheckedOut(path)) continue;
                    this.versionManager.checkin(path);
                }
                catch (RepositoryException e) {
                    if (first != null) continue;
                    first = e;
                }
            }
            if (first != null) {
                throw first;
            }
        }
    }
}

