/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.modeshape.web.jcr.rest.model.RestProperty;

public final class RestNode
extends RestItem {
    private final List<RestProperty> properties = new ArrayList<RestProperty>();
    private final List<RestNode> children = new ArrayList<RestNode>();

    public RestNode(String name, String url, String parentUrl) {
        super(name, url, parentUrl);
    }

    public RestNode addChild(RestNode child) {
        this.children.add(child);
        return this;
    }

    public RestNode addProperty(RestProperty property) {
        this.properties.add(property);
        return this;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject node = new JSONObject();
        node.put("self", (Object)this.url);
        node.put("up", (Object)this.parentUrl);
        for (RestProperty restProperty : this.properties) {
            if (restProperty.isMultiValue()) {
                node.put(restProperty.name, restProperty.getValues());
                continue;
            }
            if (restProperty.getValue() == null) continue;
            node.put(restProperty.name, (Object)restProperty.getValue());
        }
        if (!this.children.isEmpty()) {
            JSONObject children = new JSONObject();
            for (RestNode child : this.children) {
                children.put(child.name, (Object)child.toJSON());
            }
            node.put("children", (Object)children);
        }
        return node;
    }
}

