/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.jgroups.Channel;
import org.modeshape.common.util.DelegatingClassLoader;
import org.modeshape.common.util.StringURLClassLoader;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.Environment;

public class LocalEnvironment
implements Environment {
    public static final Class<? extends TransactionManagerLookup> DEFAULT_TRANSACTION_MANAGER_LOOKUP_CLASS = GenericTransactionManagerLookup.class;
    private static final String DEFAULT_CONFIGURATION_NAME = "defaultCacheContainer";
    private final Class<? extends TransactionManagerLookup> transactionManagerLookupClass;
    private final Map<String, CacheContainer> containers = new HashMap<String, CacheContainer>();

    public LocalEnvironment() {
        this.transactionManagerLookupClass = DEFAULT_TRANSACTION_MANAGER_LOOKUP_CLASS;
    }

    public LocalEnvironment(Class<? extends TransactionManagerLookup> transactionManagerLookupClass) {
        if (transactionManagerLookupClass == null) {
            transactionManagerLookupClass = DEFAULT_TRANSACTION_MANAGER_LOOKUP_CLASS;
        }
        this.transactionManagerLookupClass = transactionManagerLookupClass;
    }

    public synchronized CacheContainer getCacheContainer() throws IOException, NamingException {
        return this.getCacheContainer(null);
    }

    @Override
    public synchronized CacheContainer getCacheContainer(String name) throws IOException, NamingException {
        CacheContainer container;
        if (name == null) {
            name = DEFAULT_CONFIGURATION_NAME;
        }
        if ((container = this.containers.get(name)) == null) {
            container = this.createContainer(name);
            this.containers.put(name, container);
        }
        return container;
    }

    @Override
    public synchronized Channel getChannel(String name) {
        return null;
    }

    @Override
    public synchronized void shutdown() {
        for (CacheContainer container : this.containers.values()) {
            this.shutdown(container);
        }
        this.containers.clear();
    }

    @Override
    public ClassLoader getClassLoader(ClassLoader fallbackLoader, String ... classpathEntries) {
        StringURLClassLoader urlClassLoader;
        ArrayList<String> urls = new ArrayList<String>();
        if (classpathEntries != null) {
            for (String url : classpathEntries) {
                if (StringUtil.isBlank((String)url)) continue;
                urls.add(url);
            }
        }
        ArrayList<Object> delegatesList = new ArrayList<Object>();
        if (!urls.isEmpty() && (urlClassLoader = new StringURLClassLoader(urls)).getURLs().length > 0) {
            delegatesList.add(urlClassLoader);
        }
        ClassLoader currentLoader = this.getClass().getClassLoader();
        if (fallbackLoader != null && !fallbackLoader.equals(currentLoader)) {
            if (fallbackLoader.getParent().equals(currentLoader)) {
                currentLoader = fallbackLoader;
            } else {
                delegatesList.add(fallbackLoader);
            }
        }
        return delegatesList.isEmpty() ? currentLoader : new DelegatingClassLoader(currentLoader, delegatesList);
    }

    protected void shutdown(CacheContainer container) {
        container.stop();
    }

    protected Class<? extends TransactionManagerLookup> transactionManagerLookupClass() {
        return this.transactionManagerLookupClass;
    }

    protected TransactionManagerLookup transactionManagerLookupInstance() {
        try {
            return this.transactionManagerLookupClass().newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected CacheContainer createContainer(String configFile) throws IOException, NamingException {
        DefaultCacheManager container = null;
        if (configFile != null && !configFile.equals(DEFAULT_CONFIGURATION_NAME)) {
            configFile = configFile.trim();
            try {
                container = new DefaultCacheManager(configFile);
            }
            catch (FileNotFoundException e) {
                String jndiName = configFile;
                container = (CacheContainer)this.jndiContext().lookup(jndiName);
            }
        }
        if (container == null) {
            Configuration config = this.createDefaultConfiguration();
            GlobalConfiguration global = this.createGlobalConfiguration();
            container = this.createContainer(global, config);
        }
        return container;
    }

    protected Configuration createDefaultConfiguration() {
        FluentConfiguration configurator = new FluentConfiguration(new Configuration());
        configurator.transaction().transactionManagerLookupClass(this.transactionManagerLookupClass());
        return configurator.build();
    }

    protected GlobalConfiguration createGlobalConfiguration() {
        GlobalConfiguration global = new GlobalConfiguration();
        return global;
    }

    protected CacheContainer createContainer(GlobalConfiguration globalConfiguration, Configuration configuration) {
        return new DefaultCacheManager(globalConfiguration, configuration);
    }

    protected Context jndiContext() throws NamingException {
        return new InitialContext();
    }
}

