/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;

@ThreadSafe
public final class RepositoryChangeBus
implements ChangeBus {
    private static final String NULL_WORKSPACE_NAME = "null_workspace_name";
    private final ExecutorService executor;
    private final ConcurrentHashMap<String, ConcurrentHashMap<ChangeSetListener, BlockingQueue<ChangeSet>>> workspaceListenerQueues;
    private final Set<Future<?>> workers;
    private final Set<ChangeSetListener> listeners;
    private final ReadWriteLock listenersLock = new ReentrantReadWriteLock(true);
    protected volatile boolean shutdown;
    private final String systemWorkspaceName;

    public RepositoryChangeBus(ExecutorService executor, String systemWorkspaceName, boolean separateThreadForSystemWorkspace) {
        this.systemWorkspaceName = systemWorkspaceName;
        this.workers = new HashSet();
        this.workspaceListenerQueues = new ConcurrentHashMap();
        this.executor = executor;
        this.listeners = Collections.synchronizedSet(new LinkedHashSet());
        this.shutdown = false;
    }

    RepositoryChangeBus(ExecutorService executor) {
        this(executor, null, false);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            this.listenersLock.writeLock().lock();
            this.listeners.clear();
            this.workspaceListenerQueues.clear();
            this.stopWork();
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    private void stopWork() {
        this.executor.shutdown();
        for (Future<?> worker : this.workers) {
            worker.cancel(true);
        }
        this.workers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(ChangeSetListener listener) {
        if (listener == null) {
            return false;
        }
        try {
            this.listenersLock.writeLock().lock();
            boolean bl = this.listeners.add(listener);
            return bl;
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(ChangeSetListener listener) {
        if (listener == null) {
            return false;
        }
        try {
            this.listenersLock.writeLock().lock();
            boolean bl = this.listeners.remove(listener);
            return bl;
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(ChangeSet changeSet) {
        ConcurrentHashMap<ChangeSetListener, BlockingQueue<ChangeSet>> existingMap;
        String workspaceName;
        if (changeSet == null || !this.hasObservers()) {
            return;
        }
        if (this.shutdown) {
            throw new IllegalStateException("Change bus has been already shut down, should not be receiving events");
        }
        String string = workspaceName = changeSet.getWorkspaceName() != null ? changeSet.getWorkspaceName() : NULL_WORKSPACE_NAME;
        if (this.notifiedSystemWorkspaceListenersInline(changeSet, workspaceName)) {
            return;
        }
        ConcurrentHashMap<ChangeSetListener, BlockingQueue<ChangeSet>> listenersForWorkspace = this.workspaceListenerQueues.get(workspaceName);
        if (listenersForWorkspace == null && (existingMap = this.workspaceListenerQueues.putIfAbsent(workspaceName, listenersForWorkspace = new ConcurrentHashMap())) != null) {
            listenersForWorkspace = existingMap;
        }
        try {
            this.listenersLock.readLock().lock();
            for (ChangeSetListener listener : this.listeners) {
                BlockingQueue<ChangeSet> listenerQueue = listenersForWorkspace.get(listener);
                if (listenerQueue == null) {
                    listenerQueue = new LinkedBlockingQueue<ChangeSet>();
                    listenerQueue.add(changeSet);
                    BlockingQueue<ChangeSet> existingQueue = listenersForWorkspace.putIfAbsent(listener, listenerQueue);
                    if (existingQueue != null) {
                        listenerQueue = existingQueue;
                    }
                    ChangeSetDispatcher dispatcher = new ChangeSetDispatcher(listener, listenerQueue);
                    this.workers.add(this.executor.submit(dispatcher));
                    continue;
                }
                listenerQueue.add(changeSet);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifiedSystemWorkspaceListenersInline(ChangeSet changeSet, String workspaceName) {
        if (workspaceName.equalsIgnoreCase(this.systemWorkspaceName)) {
            this.listenersLock.readLock().lock();
            try {
                for (ChangeSetListener listener : this.listeners) {
                    listener.notify(changeSet);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.listenersLock.readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasObservers() {
        try {
            this.listenersLock.readLock().lock();
            boolean bl = !this.listeners.isEmpty();
            return bl;
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    private class ChangeSetDispatcher
    implements Callable<Void> {
        private static final int DEFAULT_POLL_TIMEOUT = 3;
        private ChangeSetListener listener;
        private BlockingQueue<ChangeSet> changeSetQueue;

        ChangeSetDispatcher(ChangeSetListener listener, BlockingQueue<ChangeSet> changeSetQueue) {
            this.listener = listener;
            this.changeSetQueue = changeSetQueue;
        }

        @Override
        public Void call() {
            while (!RepositoryChangeBus.this.shutdown) {
                try {
                    ChangeSet changeSet = this.changeSetQueue.poll(3L, TimeUnit.SECONDS);
                    if (changeSet == null) continue;
                    this.listener.notify(changeSet);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
            this.shutdown();
            return null;
        }

        private void shutdown() {
            while (!this.changeSetQueue.isEmpty()) {
                this.listener.notify((ChangeSet)this.changeSetQueue.poll());
            }
            this.listener = null;
            this.changeSetQueue = null;
        }
    }
}

