/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.Observable;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.ReadOnlySessionCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.ValueFactory;

public class RepositoryCache
implements Observable {
    private static final String SYSTEM_METADATA_IDENTIFIER = "jcr:system/mode:metadata";
    private final ExecutionContext context;
    private final RepositoryConfiguration configuration;
    private final SchematicDb database;
    private final ConcurrentHashMap<String, WorkspaceCache> workspaceCachesByName;
    private final AtomicLong minimumBinarySizeInBytes = new AtomicLong();
    private final String name;
    private final String repoKey;
    private final String sourceKey;
    private final String rootNodeId;
    private final ChangeBus changeBus;
    private final NodeKey systemMetadataKey;
    private final NodeKey systemKey;
    private final Set<String> workspaceNames;
    private final String systemWorkspaceName;
    private final Logger logger;
    private final SessionEnvironment sessionContext;
    private final boolean systemContentInitialized;
    public static final ContentInitializer NO_OP_INITIALIZER = new ContentInitializer(){

        @Override
        public void initialize(SessionCache session, MutableCachedNode parent) {
        }
    };

    public RepositoryCache(ExecutionContext context, SchematicDb database, RepositoryConfiguration configuration, ContentInitializer initializer, SessionEnvironment sessionContext, ChangeBus changeBus) {
        CachedNode systemNode;
        this.context = context;
        this.configuration = configuration;
        this.database = database;
        this.minimumBinarySizeInBytes.set(configuration.getBinaryStorage().getMinimumBinarySizeInBytes());
        this.name = configuration.getName();
        this.repoKey = NodeKey.keyForSourceName(this.name);
        this.sourceKey = NodeKey.keyForSourceName(configuration.getStoreName());
        this.rootNodeId = "/";
        this.logger = Logger.getLogger(this.getClass());
        this.workspaceCachesByName = new ConcurrentHashMap();
        this.sessionContext = sessionContext;
        this.systemWorkspaceName = "system";
        String systemWorkspaceKey = NodeKey.keyForWorkspaceName(this.systemWorkspaceName);
        this.systemMetadataKey = new NodeKey(this.sourceKey, systemWorkspaceKey, SYSTEM_METADATA_IDENTIFIER);
        this.workspaceNames = new CopyOnWriteArraySet<String>(configuration.getAllWorkspaceNames());
        this.refreshWorkspaces(false);
        this.changeBus = changeBus;
        this.changeBus.register(new LocalChangeListener());
        SessionCache systemSession = this.createSession(context, this.systemWorkspaceName, false);
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        CachedNode cachedNode = systemNode = systemRef != null ? systemSession.getNode(systemRef) : null;
        if (systemRef == null || systemNode == null) {
            this.logger.debug("Initializing the '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
            MutableCachedNode root = systemSession.mutable(systemRootKey);
            if (initializer == null) {
                initializer = NO_OP_INITIALIZER;
            }
            initializer.initialize(systemSession, root);
            systemSession.save();
            this.refreshWorkspace(this.systemWorkspaceName);
            systemSession = this.createSession(context, this.systemWorkspaceName, false);
            systemRoot = systemSession.getNode(systemRootKey);
            systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
            if (systemRef == null) {
                throw new SystemFailureException(JcrI18n.unableToInitializeSystemWorkspace.text(new Object[]{this.name}));
            }
            this.systemContentInitialized = true;
        } else {
            this.systemContentInitialized = false;
            this.logger.debug("Found existing '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
        }
        this.systemKey = systemRef.getKey();
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public NodeKey getRepositoryMetadataDocumentKey() {
        return this.systemMetadataKey;
    }

    @Override
    public boolean register(ChangeSetListener observer) {
        return this.changeBus.register(observer);
    }

    @Override
    public boolean unregister(ChangeSetListener observer) {
        return this.changeBus.unregister(observer);
    }

    public void setLargeValueSizeInBytes(long sizeInBytes) {
        assert (sizeInBytes > -1L);
        this.minimumBinarySizeInBytes.set(sizeInBytes);
        for (WorkspaceCache workspaceCache : this.workspaceCachesByName.values()) {
            assert (workspaceCache != null);
            workspaceCache.setMinimumBinarySizeInBytes(this.minimumBinarySizeInBytes.get());
        }
    }

    public long largeValueSizeInBytes() {
        return this.minimumBinarySizeInBytes.get();
    }

    public boolean isSystemContentInitialized() {
        return this.systemContentInitialized;
    }

    protected void refreshWorkspaces(boolean update) {
        DocumentTranslator translator = new DocumentTranslator(this.context, this.database, this.minimumBinarySizeInBytes.get());
        HashSet<String> workspaceNames = new HashSet<String>(this.workspaceNames);
        String systemMetadataKeyStr = this.systemMetadataKey.toString();
        SchematicEntry entry = this.database.get(systemMetadataKeyStr);
        if (entry == null) {
            PropertyFactory propFactory = this.context.getPropertyFactory();
            EditableDocument doc = Schematic.newDocument();
            translator.setKey(doc, this.systemMetadataKey);
            translator.setProperty(doc, propFactory.create(this.name("workspaces"), workspaceNames), null);
            entry = this.database.putIfAbsent(systemMetadataKeyStr, (Document)doc, null);
        }
        if (entry != null) {
            Document doc = entry.getContentAsDocument();
            Property prop = translator.getProperty(doc, this.name("workspaces"));
            if (prop != null && !prop.isEmpty() && !update) {
                workspaceNames.clear();
                ValueFactory<String> strings = this.context.getValueFactories().getStringFactory();
                for (Object value : prop) {
                    String workspaceName = strings.create(value);
                    workspaceNames.add(workspaceName);
                }
                this.workspaceNames.addAll(workspaceNames);
                this.workspaceNames.retainAll(workspaceNames);
            } else {
                EditableDocument editable = entry.editDocumentContent();
                PropertyFactory propFactory = this.context.getPropertyFactory();
                translator.setProperty(editable, propFactory.create(this.name("workspaces"), workspaceNames), null);
            }
        }
    }

    public final String getKey() {
        return this.repoKey;
    }

    public final NodeKey getSystemKey() {
        return this.systemKey;
    }

    public final String getSystemWorkspaceKey() {
        return NodeKey.keyForWorkspaceName(this.getSystemWorkspaceName());
    }

    public final String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getWorkspaceNames() {
        return Collections.unmodifiableSet(this.workspaceNames);
    }

    WorkspaceCache workspace(String name) {
        WorkspaceCache cache = this.workspaceCachesByName.get(name);
        if (cache == null) {
            if (!this.workspaceNames.contains(name) && !this.systemWorkspaceName.equals(name)) {
                throw new WorkspaceNotFoundException(name);
            }
            String workspaceKey = NodeKey.keyForWorkspaceName(name);
            NodeKey rootKey = new NodeKey(this.sourceKey, workspaceKey, this.rootNodeId);
            EditableDocument rootDoc = Schematic.newDocument();
            DocumentTranslator trans = new DocumentTranslator(this.context, this.database, Long.MAX_VALUE);
            trans.setProperty(rootDoc, this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.ROOT), null);
            trans.setProperty(rootDoc, this.context.getPropertyFactory().create(JcrLexicon.UUID, rootKey.toString()), null);
            this.database.putIfAbsent(rootKey.toString(), (Document)rootDoc, null);
            cache = new WorkspaceCache(this.context, this.getKey(), name, this.database, this.minimumBinarySizeInBytes.get(), rootKey, this.changeBus);
            WorkspaceCache existing = this.workspaceCachesByName.putIfAbsent(name, cache);
            if (existing != null) {
                cache = existing;
            } else if (!this.systemWorkspaceName.equals(name)) {
                this.logger.debug("Initializing '{0}' workspace in repository '{1}'", new Object[]{name, this.getName()});
                SessionCache systemLinker = this.createSession(this.context, name, false);
                MutableCachedNode systemNode = systemLinker.mutable(systemLinker.getRootKey());
                systemNode.linkChild(systemLinker, this.systemKey, JcrLexicon.SYSTEM);
                systemLinker.save();
            }
        }
        return cache;
    }

    void removeWorkspace(String name) {
        assert (name != null);
        assert (!this.workspaceNames.contains(name));
        WorkspaceCache removed = this.workspaceCachesByName.remove(name);
        if (removed != null) {
            removed.signalDeleted();
        }
    }

    void refreshWorkspace(String name) {
        assert (name != null);
        this.workspaceCachesByName.remove(name);
    }

    Iterable<WorkspaceCache> workspaces() {
        return this.workspaceCachesByName.values();
    }

    public WorkspaceCache createWorkspace(String name) {
        if (!this.workspaceNames.contains(name)) {
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.workspaceNames.add(name);
            this.refreshWorkspaces(true);
            SessionCache session = this.createSession(this.context, name, false);
            MutableCachedNode root = session.mutable(session.getRootKey());
            ChildReference ref = root.getChildReferences(session).getChild(JcrLexicon.SYSTEM);
            if (ref == null) {
                root.linkChild(session, this.systemKey, JcrLexicon.SYSTEM);
                session.save();
            }
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.getKey());
            changes.workspaceAdded(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
        }
        return this.workspace(name);
    }

    public boolean destroyWorkspace(String name) {
        if (this.workspaceNames.contains(name)) {
            if (this.configuration.getPredefinedWorkspaceNames().contains(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyPredefinedWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.configuration.getDefaultWorkspaceName().equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyDefaultWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.systemWorkspaceName.equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroySystemWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.workspaceNames.remove(name);
            this.refreshWorkspaces(true);
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.getKey());
            changes.workspaceRemoved(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
            return true;
        }
        return false;
    }

    public NodeCache getWorkspaceCache(String workspaceName) {
        return this.workspace(workspaceName);
    }

    public SessionCache createSession(ExecutionContext context, String workspaceName, boolean readOnly) {
        if (readOnly) {
            return new ReadOnlySessionCache(context, this.workspace(workspaceName), this.sessionContext);
        }
        return new WritableSessionCache(context, this.workspace(workspaceName), this.sessionContext);
    }

    public static interface ContentInitializer {
        public void initialize(SessionCache var1, MutableCachedNode var2);
    }

    protected class LocalChangeListener
    implements ChangeSetListener {
        protected LocalChangeListener() {
        }

        @Override
        public void notify(ChangeSet changeSet) {
            block6: {
                block5: {
                    if (changeSet == null || !RepositoryCache.this.getKey().equals(changeSet.getRepositoryKey())) {
                        return;
                    }
                    String workspaceName = changeSet.getWorkspaceName();
                    if (workspaceName == null) break block5;
                    for (WorkspaceCache cache : RepositoryCache.this.workspaces()) {
                        if (cache.getWorkspaceName().equalsIgnoreCase(workspaceName)) continue;
                        cache.notify(changeSet);
                    }
                    break block6;
                }
                HashSet<String> removedNames = new HashSet<String>();
                boolean changed = false;
                for (Change change : changeSet) {
                    if (change instanceof WorkspaceAdded) {
                        String addedName = ((WorkspaceAdded)change).getWorkspaceName();
                        if (RepositoryCache.this.getWorkspaceNames().contains(addedName)) continue;
                        changed = true;
                        continue;
                    }
                    if (!(change instanceof WorkspaceRemoved)) continue;
                    String removedName = ((WorkspaceRemoved)change).getWorkspaceName();
                    removedNames.add(removedName);
                    if (!RepositoryCache.this.getWorkspaceNames().contains(removedName)) continue;
                    changed = true;
                }
                if (!changed) break block6;
                RepositoryCache.this.refreshWorkspaces(false);
                for (String removedName : removedNames) {
                    RepositoryCache.this.removeWorkspace(removedName);
                }
            }
        }
    }
}

