/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority;
import org.eclipse.osgi.internal.verifier.BERProcessor;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.JarVerifierMessages;
import org.eclipse.osgi.internal.verifier.PKCS7DateParser;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;
import org.eclipse.osgi.util.NLS;

public class PKCS7Processor
implements CertificateChain,
JarVerifierConstant {
    private static CertificateFactory certFact;
    private String certChain;
    private Certificate[] certificates;
    private Certificate[] tsaCertificates;
    private boolean trusted;
    private Map signedAttrs;
    private Map unsignedAttrs;
    private byte[] signature;
    private String digestAlgorithm;
    private String signatureAlgorithm;
    private Certificate signerCert;
    private Date signingTime;

    static {
        try {
            certFact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            SignedBundleHook.log(e.getMessage(), 4, e);
        }
    }

    String oid2String(int[] oid) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < oid.length) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(oid[i]);
            ++i;
        }
        return sb.toString();
    }

    String findEncryption(int[] encOid) throws NoSuchAlgorithmException {
        if (Arrays.equals(DSA_OID, encOid)) {
            return "DSA";
        }
        if (Arrays.equals(RSA_OID, encOid)) {
            return "RSA";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + this.oid2String(encOid));
    }

    String findDigest(int[] digestOid) throws NoSuchAlgorithmException {
        if (Arrays.equals(SHA1_OID, digestOid)) {
            return "SHA1";
        }
        if (Arrays.equals(MD5_OID, digestOid)) {
            return "MD5";
        }
        if (Arrays.equals(MD2_OID, digestOid)) {
            return "MD2";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + this.oid2String(digestOid));
    }

    public PKCS7Processor(String certChain, boolean trusted, byte[][] certificates, long signingTime) throws CertificateException {
        this.certChain = certChain;
        this.trusted = trusted;
        this.certificates = new Certificate[certificates.length];
        int i = 0;
        while (i < certificates.length) {
            this.certificates[i] = certFact.generateCertificate(new ByteArrayInputStream(certificates[i]));
            ++i;
        }
        if (signingTime > Long.MIN_VALUE) {
            this.signingTime = new Date(signingTime);
        }
    }

    public PKCS7Processor(byte[] pkcs7, int pkcs7Offset, int pkcs7Length) throws IOException, CertificateException, NoSuchAlgorithmException {
        List certs = null;
        BERProcessor bp = new BERProcessor(pkcs7, pkcs7Offset, pkcs7Length);
        bp = bp.stepInto();
        if (!Arrays.equals(bp.getObjId(), SIGNEDDATA_OID)) {
            throw new IOException("Not a valid PKCS#7 file");
        }
        bp.stepOver();
        bp = bp.stepInto();
        bp = bp.stepInto();
        bp.stepOver();
        bp.stepOver();
        this.processEncapContentInfo(bp);
        bp.stepOver();
        if (bp.classOfTag == 2 && bp.tag == 0) {
            certs = this.processCertificates(bp);
        }
        if (certs == null || certs.size() < 1) {
            throw new SecurityException("There are no certificates in the .RSA/.DSA file!");
        }
        bp.stepOver();
        if (bp.classOfTag == 0 && bp.tag == 1) {
            bp.stepOver();
        }
        this.processSignerInfos(bp, certs);
        certs = this.constructCertPath(certs, this.signerCert);
        int numCerts = certs.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < numCerts) {
            X509Certificate x509Cert = (X509Certificate)certs.get(i);
            sb.append(x509Cert.getSubjectDN().getName());
            sb.append("; ");
            ++i;
        }
        this.certChain = sb.toString();
        this.certificates = certs.toArray(new Certificate[numCerts]);
        if (this.signingTime == null) {
            this.signingTime = PKCS7DateParser.parseDate(this);
        }
    }

    private void processEncapContentInfo(BERProcessor bp) throws IOException {
        BERProcessor encapContentBERS = bp.stepInto();
        if (Arrays.equals(encapContentBERS.getObjId(), TIMESTAMP_TST_OID)) {
            encapContentBERS.stepOver();
            BERProcessor encapContentBERS1 = encapContentBERS.stepInto();
            byte[] bytesman = encapContentBERS1.getBytes();
            BERProcessor eContentStructure = new BERProcessor(bytesman, 0, bytesman.length);
            BERProcessor eContentBER = eContentStructure.stepInto();
            int tsaVersion = eContentBER.getIntValue().intValue();
            if (tsaVersion != 1) {
                throw new IOException("Not a version 1 time-stamp token");
            }
            eContentBER.stepOver();
            eContentBER.stepOver();
            eContentBER.stepOver();
            eContentBER.stepOver();
            String dateString = new String(eContentBER.getBytes());
            if (!dateString.endsWith("Z")) {
                throw new IOException("Wrong dateformat used in time-stamp token");
            }
            int dotIndex = dateString.indexOf(46);
            StringBuffer dateFormatSB = new StringBuffer("yyyyMMddHHmmss");
            if (dotIndex != -1) {
                int noS = dateString.indexOf(90) - 1 - dotIndex;
                dateFormatSB.append('.');
                int i = 0;
                while (i < noS) {
                    dateFormatSB.append('s');
                    ++i;
                }
            }
            dateFormatSB.append("'Z'");
            try {
                SimpleDateFormat dateFormt = new SimpleDateFormat(dateFormatSB.toString());
                dateFormt.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.signingTime = dateFormt.parse(dateString);
            }
            catch (ParseException parseException) {
                throw new IOException(JarVerifierMessages.PKCS7_Parse_Signing_Time_1);
            }
        }
    }

    private List constructCertPath(List certs, Certificate targetCert) {
        ArrayList<Certificate> certsList = new ArrayList<Certificate>();
        certsList.add(targetCert);
        X509Certificate currentCert = (X509Certificate)targetCert;
        int numIteration = certs.size();
        int i = 0;
        while (i < numIteration) {
            X500Principal issuer;
            X500Principal subject = currentCert.getSubjectX500Principal();
            if (subject.equals(issuer = currentCert.getIssuerX500Principal())) break;
            currentCert = null;
            Iterator itr = certs.iterator();
            while (itr.hasNext()) {
                X509Certificate tempCert = (X509Certificate)itr.next();
                if (!tempCert.getSubjectX500Principal().equals(issuer)) continue;
                certsList.add(tempCert);
                currentCert = tempCert;
            }
            ++i;
        }
        return certsList;
    }

    public void validateCerts() throws CertificateExpiredException, CertificateNotYetValidException, InvalidKeyException, SignatureException {
        if (this.certificates == null || this.certificates.length == 0) {
            throw new SecurityException("There are no certificates in the signature block file!");
        }
        int len = this.certificates.length;
        int i = 0;
        while (i < len) {
            X509Certificate currentX509Cert = (X509Certificate)this.certificates[i];
            if (this.signingTime == null) {
                currentX509Cert.checkValidity();
            } else {
                currentX509Cert.checkValidity(this.signingTime);
            }
            try {
                if (i == len - 1) {
                    if (currentX509Cert.getSubjectDN().equals(currentX509Cert.getIssuerDN())) {
                        currentX509Cert.verify(currentX509Cert.getPublicKey());
                    }
                } else {
                    X509Certificate nextX509Cert = (X509Certificate)this.certificates[i + 1];
                    currentX509Cert.verify(nextX509Cert.getPublicKey());
                }
            }
            catch (NoSuchAlgorithmException e) {
                SignedBundleHook.log(e.getMessage(), 4, e);
                throw new SecurityException(NLS.bind(JarVerifierMessages.No_Such_Algorithm_Excep, new String[]{e.getMessage()}));
            }
            catch (NoSuchProviderException e) {
                SignedBundleHook.log(e.getMessage(), 4, e);
                throw new SecurityException(NLS.bind(JarVerifierMessages.No_Such_Provider_Excep, new String[]{e.getMessage()}));
            }
            catch (CertificateException e) {
                SignedBundleHook.log(e.getMessage(), 4, e);
                throw new SecurityException(NLS.bind(JarVerifierMessages.Validate_Certs_Certificate_Exception, new String[]{e.getMessage()}));
            }
            ++i;
        }
    }

    private Certificate processSignerInfos(BERProcessor bp, List certs) throws CertificateException, NoSuchAlgorithmException {
        bp = bp.stepInto();
        BigInteger signerInfoVersion = (bp = bp.stepInto()).getIntValue();
        if (signerInfoVersion.intValue() != 1) {
            throw new CertificateException(JarVerifierMessages.PKCS7_SignerInfo_Version_Not_Supported);
        }
        bp.stepOver();
        BERProcessor issuerAndSN = bp.stepInto();
        X500Principal signerIssuer = new X500Principal(new ByteArrayInputStream(issuerAndSN.buffer, issuerAndSN.offset, issuerAndSN.endOffset - issuerAndSN.offset));
        issuerAndSN.stepOver();
        BigInteger sn = issuerAndSN.getIntValue();
        X509Certificate newSignerCert = null;
        Iterator itr = certs.iterator();
        while (itr.hasNext()) {
            X509Certificate cert = (X509Certificate)itr.next();
            if (!cert.getIssuerX500Principal().equals(signerIssuer) || !cert.getSerialNumber().equals(sn)) continue;
            newSignerCert = cert;
            break;
        }
        if (newSignerCert == null) {
            throw new CertificateException("Signer certificate not in pkcs7block");
        }
        this.signerCert = newSignerCert;
        bp.stepOver();
        BERProcessor digestAlg = bp.stepInto();
        this.digestAlgorithm = this.findDigest(digestAlg.getObjId());
        bp.stepOver();
        this.processSignedAttributes(bp);
        BERProcessor encryptionAlg = bp.stepInto();
        this.signatureAlgorithm = this.findEncryption(encryptionAlg.getObjId());
        bp.stepOver();
        this.signature = bp.getBytes();
        bp.stepOver();
        this.processUnsignedAttributes(bp);
        return newSignerCert;
    }

    private void processUnsignedAttributes(BERProcessor bp) {
        if (bp.classOfTag == 2 && bp.tag == 1) {
            this.unsignedAttrs = new HashMap();
            BERProcessor unsignedAttrsBERS = bp.stepInto();
            do {
                BERProcessor unsignedAttrBER = unsignedAttrsBERS.stepInto();
                int[] objID = unsignedAttrBER.getObjId();
                unsignedAttrBER.stepOver();
                byte[] structure = unsignedAttrBER.getBytes();
                this.unsignedAttrs.put(objID, structure);
                unsignedAttrsBERS.stepOver();
            } while (!unsignedAttrsBERS.endOfSequence());
        }
    }

    private void processSignedAttributes(BERProcessor bp) {
        if (bp.classOfTag == 2) {
            this.signedAttrs = new HashMap();
            BERProcessor signedAttrsBERS = bp.stepInto();
            do {
                BERProcessor signedAttrBER = signedAttrsBERS.stepInto();
                int[] signedAttrObjID = signedAttrBER.getObjId();
                signedAttrBER.stepOver();
                byte[] signedAttrStructure = signedAttrBER.getBytes();
                this.signedAttrs.put(signedAttrObjID, signedAttrStructure);
                signedAttrsBERS.stepOver();
            } while (!signedAttrsBERS.endOfSequence());
            bp.stepOver();
        }
    }

    public Certificate getSigner() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0];
    }

    public Certificate getRoot() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[this.certificates.length - 1];
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    public String getChain() {
        return this.certChain;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertificateChain)) {
            return false;
        }
        if (this.certificates == null) {
            return false;
        }
        CertificateChain chain = (CertificateChain)obj;
        if (this.trusted != chain.isTrusted() || (this.certChain == null ? chain.getChain() != null : !this.certChain.equals(chain.getChain()))) {
            return false;
        }
        Certificate[] otherCerts = chain.getCertificates();
        if (otherCerts == null || this.certificates.length != otherCerts.length) {
            return false;
        }
        int i = 0;
        while (i < this.certificates.length) {
            if (!this.certificates[i].equals(otherCerts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void verifySFSignature(byte[] data, int dataOffset, int dataLength) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature sig = Signature.getInstance(String.valueOf(this.digestAlgorithm) + "with" + this.signatureAlgorithm);
        sig.initVerify(this.signerCert.getPublicKey());
        sig.update(data, dataOffset, dataLength);
        if (!sig.verify(this.signature)) {
            throw new SignatureException(JarVerifierMessages.Signature_Not_Verify);
        }
    }

    public Map getUnsignedAttrs() {
        return this.unsignedAttrs;
    }

    public Map getSignedAttrs() {
        return this.signedAttrs;
    }

    private List processCertificates(BERProcessor bp) throws CertificateException {
        ArrayList<X509Certificate> rtvList = new ArrayList<X509Certificate>(3);
        BERProcessor certsBERS = bp.stepInto();
        do {
            X509Certificate x509Cert;
            if ((x509Cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(certsBERS.buffer, certsBERS.offset, certsBERS.endOffset - certsBERS.offset))) != null) {
                rtvList.add(x509Cert);
            }
            certsBERS.stepOver();
        } while (!certsBERS.endOfSequence());
        return rtvList;
    }

    void determineTrust(CertificateTrustAuthority certsTrust) {
        try {
            certsTrust.checkTrust(this.certificates);
            if (this.tsaCertificates != null) {
                certsTrust.checkTrust(this.tsaCertificates);
            }
            this.trusted = true;
        }
        catch (CertificateException certificateException) {
            this.trusted = false;
        }
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    void setTSACertificates(Certificate[] tsaCertificates) {
        this.tsaCertificates = tsaCertificates;
    }
}

