/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddFileBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddFileBinaryStorage INSTANCE = new AddFileBinaryStorage();
    protected static final String DATA_DIR_VARIABLE = "jboss.server.data.dir";
    private String binaryStoragePathInDataDirectory;

    private AddFileBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        binaries.set("type", (Object)"file");
        int minBinSize = ModelAttributes.MINIMUM_BINARY_SIZE.resolveModelAttribute(context, model).asInt();
        binaries.set("minimumBinarySizeInBytes", (Object)minBinSize);
        String defaultPath = "modeshape/" + repositoryName + "/binaries";
        ModelNode pathNode = ModelAttributes.PATH.resolveModelAttribute(context, model);
        String path = pathNode.isDefined() ? pathNode.asString() : defaultPath;
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, model).asString();
        if (model.has("relative-to") && model.get("relative-to").asString().contains(DATA_DIR_VARIABLE)) {
            this.binaryStoragePathInDataDirectory = path;
        }
        path = relativeTo + path;
        binaries.set("directory", (Object)path);
    }

    @Override
    protected void addControllersAndDependencies(String repositoryName, BinaryStorageService service, ServiceBuilder<BinaryStorage> builder, List<ServiceController<?>> newControllers, ServiceTarget target) {
        if (this.binaryStoragePathInDataDirectory != null) {
            ServiceName serviceName = ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName);
            newControllers.add(RelativePathService.addService((ServiceName)serviceName, (String)this.binaryStoragePathInDataDirectory, (String)DATA_DIR_VARIABLE, (ServiceTarget)target));
            builder.addDependency(serviceName, String.class, service.getBinaryStorageBasePathInjector());
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddFileBinaryStorage.populate(operation, model, "file-binary-storage", ModelAttributes.FILE_BINARY_STORAGE_ATTRIBUTES);
    }
}

