/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.Arrays;

public class HintStatisticBoxes
extends AbstractBox {
    private long bytesSent;
    public static final String TYPE1 = "trpy";
    public static final String TYPE2 = "totl";
    public static final String TYPE3 = "tpyl";
    public static final String TYPE4 = "tpay";
    public static final String TYPE5 = "dmed";
    public static final String TYPE6 = "dimm";
    public static final String TYPE7 = "drep";

    public HintStatisticBoxes(byte[] type) {
        super(type);
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    protected long getContentSize() {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3))) {
            return 8L;
        }
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            return 4L;
        }
        throw new UnsupportedOperationException();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7))) {
            isos.writeUInt64(this.bytesSent);
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            isos.writeUInt32((int)this.bytesSent);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7))) {
            this.bytesSent = in.readUInt64();
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            this.bytesSent = in.readUInt32();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public String toString() {
        return "HintStatistic[type=" + IsoFile.bytesToFourCC(this.getType()) + ";bytes=" + Long.toHexString(this.bytesSent) + "]";
    }
}

