/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddCustomBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddCustomBinaryStorage INSTANCE = new AddCustomBinaryStorage();

    private AddCustomBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        binaries.set("type", (Object)"custom");
        int minBinSize = ModelAttributes.MINIMUM_BINARY_SIZE.resolveModelAttribute(context, model).asInt();
        binaries.set("minimumBinarySizeInBytes", (Object)minBinSize);
        for (Property property : model.asPropertyList()) {
            String name = property.getName();
            if (name.equals("classname")) {
                name = "classname";
            } else if (name.equals("module")) {
                name = "classloader";
            }
            binaries.set(name, (Object)property.getValue());
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCustomBinaryStorage.populate(operation, model, "custom-index-storage", ModelAttributes.CUSTOM_INDEX_STORAGE_ATTRIBUTES);
    }
}

