/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.WebdavStatus;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.fromcatalina.XMLHelper;
import net.sf.webdav.fromcatalina.XMLWriter;
import net.sf.webdav.locking.LockedObject;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.AbstractMethod;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DoProppatch
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoProppatch.class);
    private boolean _readOnly;
    private IWebdavStore _store;
    private ResourceLocks _resourceLocks;

    public DoProppatch(IWebdavStore store, ResourceLocks resLocks, boolean readOnly) {
        this._readOnly = readOnly;
        this._store = store;
        this._resourceLocks = resLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        if (this._readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        String parentPath = this.getParentPath(this.getCleanPath(path));
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
            errorList.put(parentPath, 423);
            this.sendReport(req, resp, errorList);
            return;
        }
        if (!this.checkLocks(transaction, req, resp, this._resourceLocks, path)) {
            errorList.put(path, 423);
            this.sendReport(req, resp, errorList);
            return;
        }
        String tempLockOwner = "doProppatch" + System.currentTimeMillis() + req.toString();
        if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
            StoredObject so = null;
            LockedObject lo = null;
            try {
                so = this._store.getStoredObject(transaction, path);
                lo = this._resourceLocks.getLockedObjectByPath(transaction, this.getCleanPath(path));
                if (so == null) {
                    resp.sendError(404);
                    return;
                }
                if (so.isNullResource()) {
                    String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                    resp.addHeader("Allow", methodsAllowed);
                    resp.sendError(405);
                    return;
                }
                if (lo != null && lo.isExclusive()) {
                    errorList = new Hashtable();
                    errorList.put(path, new Integer(423));
                    this.sendReport(req, resp, errorList);
                    return;
                }
                List<String> toset = null;
                List<String> toremove = null;
                Vector<String> tochange = new Vector<String>();
                path = this.getCleanPath(this.getRelativePath(req));
                Node tosetNode = null;
                Node toremoveNode = null;
                if (req.getContentLength() != 0) {
                    DocumentBuilder documentBuilder = this.getDocumentBuilder();
                    try {
                        Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                        Element rootElement = document.getDocumentElement();
                        tosetNode = XMLHelper.findSubElement(XMLHelper.findSubElement(rootElement, "set"), "prop");
                        toremoveNode = XMLHelper.findSubElement(XMLHelper.findSubElement(rootElement, "remove"), "prop");
                    }
                    catch (Exception e) {
                        resp.sendError(500);
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
                    }
                } else {
                    resp.sendError(500);
                    return;
                }
                HashMap<String, String> namespaces = new HashMap<String, String>();
                namespaces.put("DAV:", "D");
                if (tosetNode != null) {
                    toset = XMLHelper.getPropertiesFromXML(tosetNode);
                    tochange.addAll(toset);
                }
                if (toremoveNode != null) {
                    toremove = XMLHelper.getPropertiesFromXML(toremoveNode);
                    tochange.addAll(toremove);
                }
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                XMLWriter generatedXML = new XMLWriter(resp.getWriter(), namespaces);
                generatedXML.writeXMLHeader();
                generatedXML.writeElement("DAV::multistatus", 0);
                generatedXML.writeElement("DAV::response", 0);
                String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
                generatedXML.writeElement("DAV::href", 0);
                String href = req.getContextPath();
                href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
                if (so.isFolder() && !href.endsWith("/")) {
                    href = href + "/";
                }
                generatedXML.writeText(this.rewriteUrl(href));
                generatedXML.writeElement("DAV::href", 1);
                for (String property : tochange) {
                    generatedXML.writeElement("DAV::propstat", 0);
                    generatedXML.writeElement("DAV::prop", 0);
                    generatedXML.writeElement(property, 2);
                    generatedXML.writeElement("DAV::prop", 1);
                    generatedXML.writeElement("DAV::status", 0);
                    generatedXML.writeText(status);
                    generatedXML.writeElement("DAV::status", 1);
                    generatedXML.writeElement("DAV::propstat", 1);
                }
                generatedXML.writeElement("DAV::response", 1);
                generatedXML.writeElement("DAV::multistatus", 1);
                generatedXML.sendData();
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            finally {
                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }
}

