/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;

public class InfinispanUtil {
    private InfinispanUtil() {
    }

    public static <K, V> Sequence<K> getAllKeys(Cache<K, V> cache) {
        if (cache.getAdvancedCache().getRpcManager() == null) {
            return new IteratorSequence(cache.keySet().iterator());
        }
        DefaultExecutorService distributedExecutor = new DefaultExecutorService(cache);
        List futures = distributedExecutor.submitEverywhere(new GetAllKeys());
        return new DistributedKeySequence(futures);
    }

    protected static class DistributedKeySequence<T>
    implements Sequence<T> {
        private final List<Future<Set<T>>> futures;
        private Iterator<T> currentIter;

        protected DistributedKeySequence(List<Future<Set<T>>> futures) {
            this.futures = new LinkedList<Future<Set<T>>>(futures);
        }

        @Override
        public T next() throws ExecutionException, CancellationException, InterruptedException {
            while (!this.futures.isEmpty()) {
                if (this.currentIter == null) {
                    do {
                        Iterator<Future<Set<T>>> futureIter = this.futures.iterator();
                        while (futureIter.hasNext()) {
                            Future<Set<T>> future = futureIter.next();
                            try {
                                Set<T> keys = future.get(100L, TimeUnit.MILLISECONDS);
                                futureIter.remove();
                                this.currentIter = keys.iterator();
                            }
                            catch (TimeoutException timeoutException) {}
                        }
                    } while (!this.futures.isEmpty());
                    if (this.currentIter == null) {
                        return null;
                    }
                }
                while (this.currentIter.hasNext()) {
                    T key = this.currentIter.next();
                    if (key == null) continue;
                    return key;
                }
                this.currentIter = null;
            }
            return null;
        }
    }

    protected static final class GetAllKeys<K, V>
    implements DistributedCallable<K, V, Set<K>> {
        private Set<K> keys;

        protected GetAllKeys() {
        }

        public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
            this.keys = inputKeys;
        }

        public Set<K> call() throws Exception {
            return this.keys;
        }
    }

    public static final class IteratorSequence<T>
    implements Sequence<T> {
        private final Iterator<T> iterator;

        public IteratorSequence(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public T next() {
            return this.iterator.hasNext() ? (T)this.iterator.next() : null;
        }
    }

    public static interface Sequence<T> {
        public T next() throws ExecutionException, CancellationException, InterruptedException;
    }
}

