/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.methods.AbstractMethod;
import org.modeshape.webdav.methods.DeterminableMethod;

public class DoMkcol
extends AbstractMethod {
    private static Logger LOG = Logger.getLogger(DoMkcol.class);
    private final IWebdavStore store;
    private final IResourceLocks resourceLocks;
    private boolean readOnly;

    public DoMkcol(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName(), new Object[0]);
        if (!this.readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(this.getCleanPath(path));
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.isUnlocked(transaction, req, this.resourceLocks, parentPath)) {
                resp.sendError(403);
                return;
            }
            String tempLockOwner = "doMkcol" + System.currentTimeMillis() + req.toString();
            if (this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                StoredObject so = null;
                try {
                    StoredObject parentSo = this.store.getStoredObject(transaction, parentPath);
                    if (parentSo == null) {
                        resp.sendError(409);
                        return;
                    }
                    if (parentPath != null && parentSo.isFolder()) {
                        so = this.store.getStoredObject(transaction, path);
                        if (so == null) {
                            this.store.createFolder(transaction, path);
                            resp.setStatus(201);
                        }
                        if (so.isNullResource()) {
                            LockedObject nullResourceLo = this.resourceLocks.getLockedObjectByPath(transaction, path);
                            if (nullResourceLo == null) {
                                resp.sendError(500);
                                return;
                            }
                            String nullResourceLockToken = nullResourceLo.getID();
                            String[] lockTokens = this.getLockIdFromIfHeader(req);
                            String lockToken = null;
                            if (lockTokens == null) {
                                resp.sendError(400);
                                return;
                            }
                            lockToken = lockTokens[0];
                            if (lockToken.equals(nullResourceLockToken)) {
                                so.setNullResource(false);
                                so.setFolder(true);
                                String[] nullResourceLockOwners = nullResourceLo.getOwner();
                                String owner = null;
                                if (nullResourceLockOwners != null) {
                                    owner = nullResourceLockOwners[0];
                                }
                                if (this.resourceLocks.unlock(transaction, lockToken, owner)) {
                                    resp.setStatus(201);
                                }
                                resp.sendError(500);
                            }
                            errorList.put(path, 423);
                            this.sendReport(req, resp, errorList);
                        }
                        String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.sendError(405);
                    }
                    if (parentPath != null && parentSo.isResource()) {
                        String methodsAllowed = DeterminableMethod.determineMethodsAllowed(parentSo);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.sendError(405);
                    }
                    resp.sendError(403);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }
}

