/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.methods.AbstractMethod;

public class DoPut
extends AbstractMethod {
    private static Logger LOG = Logger.getLogger(DoPut.class);
    private final IWebdavStore store;
    private final IResourceLocks resourceLocks;
    private final boolean readOnly;
    private final boolean lazyFolderCreationOnPut;
    private String userAgent;

    public DoPut(IWebdavStore store, IResourceLocks resLocks, boolean readOnly, boolean lazyFolderCreationOnPut) {
        this.store = store;
        this.resourceLocks = resLocks;
        this.readOnly = readOnly;
        this.lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName(), new Object[0]);
        if (!this.readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            this.userAgent = req.getHeader("User-Agent");
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.isUnlocked(transaction, req, this.resourceLocks, parentPath)) {
                resp.setStatus(423);
                return;
            }
            if (!this.isUnlocked(transaction, req, this.resourceLocks, path)) {
                resp.setStatus(423);
                return;
            }
            String tempLockOwner = "doPut" + System.currentTimeMillis() + req.toString();
            if (this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                StoredObject so = null;
                try {
                    StoredObject parentSo = this.store.getStoredObject(transaction, parentPath);
                    if (parentPath != null && parentSo != null && parentSo.isResource()) {
                        resp.sendError(403);
                        return;
                    }
                    if (parentPath != null && parentSo == null && this.lazyFolderCreationOnPut) {
                        this.store.createFolder(transaction, parentPath);
                    } else if (parentPath != null && parentSo == null && !this.lazyFolderCreationOnPut) {
                        errorList.put(parentPath, 404);
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    so = this.store.getStoredObject(transaction, path);
                    if (so == null) {
                        this.store.createResource(transaction, path);
                    } else if (so.isNullResource()) {
                        LockedObject nullResourceLo = this.resourceLocks.getLockedObjectByPath(transaction, path);
                        if (nullResourceLo == null) {
                            resp.sendError(500);
                            return;
                        }
                        String nullResourceLockToken = nullResourceLo.getID();
                        String[] lockTokens = this.getLockIdFromIfHeader(req);
                        String lockToken = null;
                        if (lockTokens == null) {
                            resp.sendError(400);
                            return;
                        }
                        lockToken = lockTokens[0];
                        if (lockToken.equals(nullResourceLockToken)) {
                            so.setNullResource(false);
                            so.setFolder(false);
                            String[] nullResourceLockOwners = nullResourceLo.getOwner();
                            String owner = null;
                            if (nullResourceLockOwners != null) {
                                owner = nullResourceLockOwners[0];
                            }
                            if (!this.resourceLocks.unlock(transaction, lockToken, owner)) {
                                resp.sendError(500);
                            }
                        } else {
                            errorList.put(path, 423);
                            this.sendReport(req, resp, errorList);
                        }
                    }
                    this.doUserAgentWorkaround(resp);
                    long resourceLength = this.store.setResourceContent(transaction, path, (InputStream)req.getInputStream(), null, null);
                    so = this.store.getStoredObject(transaction, path);
                    if (resourceLength == -1L) return;
                    so.setResourceLength(resourceLength);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    private void doUserAgentWorkaround(HttpServletResponse resp) {
        if (this.userAgent != null && this.userAgent.contains("WebDAVFS") && !this.userAgent.contains("Transmit")) {
            LOG.trace("DoPut.execute() : do workaround for user agent '" + this.userAgent + "'", new Object[0]);
            resp.setStatus(201);
        } else if (this.userAgent != null && this.userAgent.contains("Transmit")) {
            LOG.trace("DoPut.execute() : do workaround for user agent '" + this.userAgent + "'", new Object[0]);
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
    }
}

