/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoHead;

public class DoHeadTest
extends AbstractWebDAVTest {
    @Test
    public void testAccessOfaMissingPageResultsIn404() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getPathInfo();
                this.will(1.returnValue((Object)"/index.html"));
                Object indexSo = null;
                ((IWebdavStore)this.one(DoHeadTest.this.mockStore)).getStoredObject(DoHeadTest.this.mockTransaction, "/index.html");
                this.will(1.returnValue(indexSo));
                ((HttpServletResponse)this.one(DoHeadTest.this.mockRes)).setStatus(404);
            }
        });
        DoHead doHead = new DoHead(this.mockStore, null, null, new ResourceLocks(), this.mockMimeTyper, 0);
        doHead.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testAccessOfaPageResultsInPage() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/index.html"));
                StoredObject indexSo = DoHeadTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoHeadTest.this.mockStore)).getStoredObject(DoHeadTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue((Object)indexSo));
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getHeader("If-None-Match");
                this.will(2.returnValue(null));
                ((HttpServletResponse)this.one(DoHeadTest.this.mockRes)).setDateHeader("last-modified", indexSo.getLastModified().getTime());
                ((HttpServletResponse)this.one(DoHeadTest.this.mockRes)).addHeader((String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)));
                ((IMimeTyper)this.one(DoHeadTest.this.mockMimeTyper)).getMimeType(DoHeadTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue((Object)"text/foo"));
                ((HttpServletResponse)this.one(DoHeadTest.this.mockRes)).setContentType("text/foo");
            }
        });
        DoHead doHead = new DoHead(this.mockStore, null, null, new ResourceLocks(), this.mockMimeTyper, 0);
        doHead.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testAccessOfaDirectoryResultsInRedirectIfDefaultIndexFilePresent() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/foo/"));
                StoredObject fooSo = DoHeadTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoHeadTest.this.mockStore)).getStoredObject(DoHeadTest.this.mockTransaction, "/foo/");
                this.will(3.returnValue((Object)fooSo));
                ((HttpServletRequest)this.one(DoHeadTest.this.mockReq)).getRequestURI();
                this.will(3.returnValue((Object)"/foo/"));
                ((HttpServletResponse)this.one(DoHeadTest.this.mockRes)).encodeRedirectURL("/foo//indexFile");
                ((HttpServletResponse)this.one(DoHeadTest.this.mockRes)).sendRedirect("");
            }
        });
        DoHead doHead = new DoHead(this.mockStore, "/indexFile", null, new ResourceLocks(), this.mockMimeTyper, 0);
        doHead.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

