/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.QueryResult;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.LocalJcrDriver;
import org.modeshape.jdbc.delegate.AbstractRepositoryDelegate;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.HttpQueryResult;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonRestClient;

public class HttpRepositoryDelegate
extends AbstractRepositoryDelegate {
    protected static final int PROTOCOL_HTTP = 2;
    public static final RepositoryDelegateFactory FACTORY = new RepositoryDelegateFactory(){

        @Override
        protected int determineProtocol(String url) {
            if (url.startsWith("jdbc:jcr:http://") && url.length() > "jdbc:jcr:http://".length()) {
                return 2;
            }
            return super.determineProtocol(url);
        }

        @Override
        protected RepositoryDelegate create(int protocol, String url, Properties info, LocalJcrDriver.JcrContextFactory contextFactory) {
            if (protocol == 2) {
                return new HttpRepositoryDelegate(url, info);
            }
            return super.create(protocol, url, info, contextFactory);
        }
    };
    private static final String HTTP_EXAMPLE_URL = "jdbc:jcr:http://{hostname}:{port}/{context root}";
    private JsonRestClient restClient;
    private Workspace workspace = null;
    private Map<String, NodeType> nodeTypes;
    private final Lock nodeTypeLock = new ReentrantLock();
    private Repository remoteRepository;

    public HttpRepositoryDelegate(String url, Properties info) {
        super(url, info);
    }

    @Override
    protected ConnectionInfo createConnectionInfo(String url, Properties info) {
        return new HttpConnectionInfo(url, info);
    }

    @Override
    public QueryResult execute(String query, String language) throws RepositoryException {
        this.logger.trace("Executing query: {0}", query);
        try {
            List<QueryRow> results = this.restClient.query(this.workspace, language, query);
            return new HttpQueryResult(results);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public String getDescriptor(String descriptorKey) {
        return this.remoteRepository != null ? this.remoteRepository.getMetadata().get(descriptorKey).toString() : "";
    }

    @Override
    public NodeType nodeType(String name) throws RepositoryException {
        NodeType nodetype;
        if (this.nodeTypes == null) {
            this.nodeTypes();
        }
        if ((nodetype = this.nodeTypes.get(name)) == null) {
            throw new RepositoryException(JdbcLocalI18n.unableToGetNodeType.text(name));
        }
        return nodetype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeType> nodeTypes() throws RepositoryException {
        try {
            this.nodeTypeLock.lock();
            if (this.nodeTypes == null) {
                try {
                    Map<String, NodeType> nodeTypesByName = this.restClient.getNodeTypes(this.workspace.getRepository());
                    if (nodeTypesByName == null || nodeTypesByName.isEmpty()) {
                        String msg = JdbcLocalI18n.noNodeTypesReturned.text(this.workspace.getServer().getUrl() + "/" + this.workspace.getRepository().getName() + "/" + this.workspace.getName());
                        throw new RepositoryException(msg);
                    }
                    this.nodeTypes = nodeTypesByName;
                }
                catch (Exception e) {
                    throw new RepositoryException(JdbcLocalI18n.unableToGetNodeTypes.text(this.workspace.getRepository().getName()), e);
                }
            }
            ArrayList<NodeType> arrayList = new ArrayList<NodeType>(this.nodeTypes.values());
            return arrayList;
        }
        finally {
            this.nodeTypeLock.unlock();
        }
    }

    @Override
    protected void retrieveRepository() throws SQLException {
        this.logger.debug("Creating repository for HttpRepositoryDelegate", new Object[0]);
        ConnectionInfo info = this.getConnectionInfo();
        assert (info != null);
        String path = info.getRepositoryPath();
        if (path == null) {
            throw new SQLException("Missing repo path from " + info.getUrl());
        }
        if (info.getUsername() == null) {
            throw new SQLException("Missing username from " + info.getUrl());
        }
        if (info.getPassword() == null) {
            throw new SQLException("Missing password path from " + info.getUrl());
        }
        String expectedRepositoryName = info.getRepositoryName();
        if (expectedRepositoryName == null) {
            throw new SQLException("Missing repo name from " + info.getUrl());
        }
        Server server = new Server("http://" + path, info.getUsername(), new String(info.getPassword()));
        Repository repo = new Repository(expectedRepositoryName, server);
        this.workspace = new Workspace(info.getWorkspaceName(), repo);
        this.restClient = new JsonRestClient();
        try {
            TreeSet<String> repositoryNames = new TreeSet<String>();
            Collection<Repository> repositories = this.restClient.getRepositories(server);
            for (Repository repository : repositories) {
                String repositoryName = repository.getName();
                repositoryNames.add(repositoryName);
                if (!repositoryName.equalsIgnoreCase(expectedRepositoryName)) continue;
                this.remoteRepository = repository;
            }
            if (this.remoteRepository == null) {
                throw new SQLException(JdbcLocalI18n.unableToFindNamedRepository.text(path, expectedRepositoryName));
            }
            this.setRepositoryNames(repositoryNames);
        }
        catch (Exception e) {
            throw new SQLException(JdbcLocalI18n.noRepositoryNamesFound.text(new Object[0]), e);
        }
    }

    @Override
    public boolean isValid(int timeout) {
        try {
            this.restClient.getWorkspaces(this.workspace.getRepository());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void close() {
        super.close();
        this.restClient = null;
        this.workspace = null;
        if (this.nodeTypes != null) {
            this.nodeTypes.clear();
        }
    }

    private class HttpConnectionInfo
    extends ConnectionInfo {
        protected HttpConnectionInfo(String url, Properties properties) {
            super(url, properties);
        }

        @Override
        protected void init() {
            super.init();
            StringBuilder url = new StringBuilder();
            String[] urlsections = this.repositoryPath.split("/");
            if (urlsections.length < 3) {
                return;
            }
            int workspacePos = -1;
            int repositoryPos = -1;
            int repoPos = 1;
            if (this.getWorkspaceName() == null && urlsections.length > 3) {
                workspacePos = urlsections.length - 1;
                String workspaceName = urlsections[workspacePos];
                this.setWorkspaceName(workspaceName);
                repoPos = 2;
            }
            if (this.getRepositoryName() == null && urlsections.length > 2) {
                repositoryPos = urlsections.length - repoPos;
                String repositoryName = urlsections[repositoryPos];
                this.setRepositoryName(repositoryName);
            }
            for (int i = 0; i < repositoryPos; ++i) {
                url.append(urlsections[i]);
                if (i >= repositoryPos - 1) continue;
                url.append("/");
            }
            this.repositoryPath = url.toString();
        }

        @Override
        public String getUrlExample() {
            return HttpRepositoryDelegate.HTTP_EXAMPLE_URL;
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:jcr:http://";
        }

        @Override
        protected void addUrlPropertyInfo(List<DriverPropertyInfo> results) {
            if (!this.repositoryPath.contains("/")) {
                this.setUrl(null);
            }
            super.addUrlPropertyInfo(results);
        }
    }
}

