/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.read_committed;

import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockTestBase;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.read_committed.ReadCommittedLockTest")
public class ReadCommittedLockTest
extends LockTestBase {
    public ReadCommittedLockTest() {
        this.repeatableRead = false;
    }

    public void testVisibilityOfCommittedDataPut() throws Exception {
        Cache<String, String> c = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).cache;
        c.put((Object)"k", (Object)"v");
        assert ("v".equals(c.get((Object)"k")));
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.begin();
        assert ("v".equals(c.get((Object)"k")));
        assert ("v".equals(c.get((Object)"k")));
        Transaction reader = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.suspend();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.begin();
        c.put((Object)"k", (Object)"v2");
        Transaction writer = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.suspend();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.resume(reader);
        assert ("v".equals(c.get((Object)"k"))) : "Should not read uncommitted data";
        reader = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.suspend();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.resume(writer);
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.commit();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.resume(reader);
        assert ("v2".equals(c.get((Object)"k"))) : "Should read committed data";
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.commit();
    }

    public void testVisibilityOfCommittedDataReplace() throws Exception {
        Cache<String, String> c = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).cache;
        c.put((Object)"k", (Object)"v");
        assert ("v".equals(c.get((Object)"k")));
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.begin();
        assert ("v".equals(c.get((Object)"k")));
        assert ("v".equals(c.get((Object)"k")));
        Transaction reader = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.suspend();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.begin();
        c.replace((Object)"k", (Object)"v2");
        Transaction writer = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.suspend();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.resume(reader);
        assert ("v".equals(c.get((Object)"k"))) : "Should not read uncommitted data";
        reader = ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.suspend();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.resume(writer);
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.commit();
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.resume(reader);
        assert ("v2".equals(c.get((Object)"k"))) : "Should read committed data";
        ((LockTestBase.LockTestBaseTL)this.threadLocal.get()).tm.commit();
    }

    @Override
    public void testConcurrentWriters() throws Exception {
        super.testConcurrentWriters();
    }
}

