/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.config.parsing.ConfigFilesConvertor;
import org.infinispan.config.parsing.Jbc2InfinispanTransformerTest;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.parsing.Coherence2InfinispanTransformerTest", enabled=false)
public class Coherence2InfinispanTransformerTest
extends AbstractInfinispanTest {
    private static final String BASE_DIR = "configs/coherence";
    ConfigFilesConvertor convertor = new ConfigFilesConvertor();

    public void testDefaultConfigFile() throws Exception {
        this.testAllFile("/default-config.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllFile(String coherenceFileName) throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        EmbeddedCacheManager dcm = null;
        Object sampleDistributedCache2 = null;
        try {
            Jbc2InfinispanTransformerTest.TestClassLoader delegatingCl = new Jbc2InfinispanTransformerTest.TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            String fileName = this.getFileName(coherenceFileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, (String)ConfigFilesConvertor.TRANSFORMATIONS.get("Coherence35x"), Thread.currentThread().getContextClassLoader());
            dcm = TestCacheManagerFactory.fromStream(new ByteArrayInputStream(baos.toByteArray()));
            Cache defaultCache = dcm.getCache();
            defaultCache.put((Object)"key", (Object)"value");
            Cache cache = dcm.getCache("dist-*");
            cache.put((Object)"a", (Object)"v");
            Thread.currentThread().setContextClassLoader(existingCl);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(existingCl);
            TestingUtil.killCaches(new Cache[]{sampleDistributedCache2});
            TestingUtil.killCacheManagers(new CacheContainer[]{dcm});
            throw throwable;
        }
        TestingUtil.killCaches(new Cache[]{sampleDistributedCache2});
        TestingUtil.killCacheManagers(new CacheContainer[]{dcm});
    }

    private String getFileName(String s) {
        return BASE_DIR + File.separator + s;
    }
}

