/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.distribution.rehash.RehashTestBase;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.SingleJoinTest")
public class SingleJoinTest
extends RehashTestBase {
    EmbeddedCacheManager joinerManager;
    Cache<Object, String> joiner;

    @Override
    void performRehashEvent(boolean offline) {
        this.joinerManager = this.addClusterEnabledCacheManager(new TransportFlags().withFD(true));
        this.joinerManager.defineConfiguration(this.cacheName, this.configuration);
        this.joiner = this.joinerManager.getCache(this.cacheName);
    }

    @Override
    void waitForRehashCompletion() {
        ArrayList<Cache<Object, String>> allCaches = new ArrayList<Cache<Object, String>>(this.caches);
        allCaches.add(this.joiner);
        TestingUtil.blockUntilViewsReceived(60000, allCaches);
        this.waitForClusterToForm(this.cacheName);
        int joinerPos = this.locateJoiner(this.joinerManager.getAddress());
        this.log.info((Object)("***>>> Joiner is in position " + joinerPos));
        this.cacheManagers.add(joinerPos, this.joinerManager);
        this.caches.add(joinerPos, this.joiner);
    }
}

