/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.io.File;
import java.util.HashMap;
import org.infinispan.AdvancedCache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.BatchAsyncCacheStoreTest")
public class BatchAsyncCacheStoreTest
extends SingleCacheManagerTest {
    private final HashMap cacheCopy = new HashMap();
    private String tmpDirectory;

    public BatchAsyncCacheStoreTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setCacheMode(Configuration.CacheMode.LOCAL);
        configuration.setInvocationBatchingEnabled(true);
        this.enableTestJdbcStorage(configuration);
        return TestCacheManagerFactory.createCacheManager(configuration);
    }

    private void enableTestJdbcStorage(Configuration configuration) throws Exception {
        CacheStoreConfig fileStoreConfiguration = this.createCacheStoreConfig();
        AsyncStoreConfig asyncStoreConfig = new AsyncStoreConfig();
        asyncStoreConfig.setEnabled(Boolean.valueOf(true));
        asyncStoreConfig.setThreadPoolSize(Integer.valueOf(1));
        fileStoreConfiguration.setAsyncStoreConfig(asyncStoreConfig);
        CacheLoaderManagerConfig loaderManagerConfig = configuration.getCacheLoaderManagerConfig();
        loaderManagerConfig.setPassivation(Boolean.valueOf(false));
        loaderManagerConfig.setPreload(Boolean.valueOf(false));
        loaderManagerConfig.setShared(Boolean.valueOf(true));
        loaderManagerConfig.addCacheLoaderConfig((CacheLoaderConfig)fileStoreConfiguration);
    }

    @Test
    public void sequantialOvewritingInBatches() {
        this.cache = this.cacheManager.getCache();
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        int i = 0;
        while (i < 2000) {
            advancedCache.startBatch();
            this.putAValue((AdvancedCache<Object, Object>)advancedCache, i++);
            this.putAValue((AdvancedCache<Object, Object>)advancedCache, i++);
            advancedCache.endBatch(true);
        }
        this.cacheCopy.putAll(this.cache);
        this.cache.stop();
        this.cacheManager.stop();
    }

    private void putAValue(AdvancedCache<Object, Object> advancedCache, int i) {
        String key = "k" + i % 13;
        String value = "V" + i;
        advancedCache.put((Object)key, (Object)value);
    }

    @Test(dependsOnMethods={"sequantialOvewritingInBatches"})
    public void indexWasStored() {
        this.cache = this.cacheManager.getCache();
        assert (this.cache.isEmpty());
        boolean failed = false;
        for (Object key : this.cacheCopy.keySet()) {
            Object actual;
            Object expected = this.cacheCopy.get(key);
            if (expected.equals(actual = this.cache.get(key))) continue;
            this.log.errorf("Failure on key '%s' expected value: '%s' actual value: '%s'", (Object)key.toString(), expected, actual);
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
        Assert.assertEquals((int)this.cacheCopy.keySet().size(), (int)this.cache.keySet().size(), (String)"have a different number of keys");
    }

    @BeforeClass
    @Parameters(value={"basedir"})
    protected void setUpTempDir(@Optional(value="/tmp") String basedir) {
        this.tmpDirectory = TestingUtil.tmpDirectory(basedir, this);
        new File(this.tmpDirectory).mkdirs();
    }

    @AfterClass
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.tmpDirectory);
    }

    protected CacheStoreConfig createCacheStoreConfig() throws Exception {
        FileCacheStoreConfig cfg = new FileCacheStoreConfig();
        cfg.setLocation(this.tmpDirectory);
        return cfg;
    }
}

