/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.replicated.optimistic;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractNoCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.replicated.optimistic.BasicSingleLockRepOptTest")
public class BasicSingleLockReplOptTest
extends AbstractNoCrashTest {
    public BasicSingleLockReplOptTest() {
        super(Configuration.CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, false);
    }

    @Override
    protected void testTxAndLockOnDifferentNodes(AbstractNoCrashTest.Operation operation, boolean addFirst, boolean removed) throws Exception {
        if (addFirst) {
            this.cache(0).put((Object)"k", (Object)"v_initial");
        }
        this.assertNotLocked("k");
        this.tm(0).begin();
        operation.perform("k", 0);
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        assert (this.lockManager(0).isLocked((Object)"k"));
        assert (!this.lockManager(1).isLocked((Object)"k"));
        assert (!this.lockManager(2).isLocked((Object)"k"));
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertNotLocked("k");
        this.assertValue("k", removed);
    }

    public void testMultipleLocksInSameTx() throws Exception {
        String k1 = "k1";
        String k2 = "k2";
        this.tm(0).begin();
        this.cache(0).put((Object)k1, (Object)"v");
        this.cache(0).put((Object)k2, (Object)"v");
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        assert (this.lockManager(0).isLocked((Object)k1));
        assert (this.lockManager(0).isLocked((Object)k2));
        assert (!this.lockManager(1).isLocked((Object)k1));
        assert (!this.lockManager(1).isLocked((Object)k2));
        assert (!this.lockManager(1).isLocked((Object)k2));
        assert (!this.lockManager(2).isLocked((Object)k2));
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertNotLocked(k1);
        this.assertNotLocked(k2);
        this.assertValue(k1, false);
        this.assertValue(k2, false);
    }

    @Override
    public void testTxAndLockOnSameNode() throws Exception {
        this.tm(0).begin();
        this.cache(0).put((Object)"k0", (Object)"v");
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        assert (this.lockManager(0).isLocked((Object)"k0"));
        assert (!this.lockManager(1).isLocked((Object)"k0"));
        assert (!this.lockManager(2).isLocked((Object)"k0"));
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertNotLocked("k0");
        this.assertValue("k0", false);
    }

    public void testSecondTxCannotPrepare() throws Exception {
        this.tm(0).begin();
        this.cache(0).put((Object)"k0", (Object)"v");
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        this.tm(0).suspend();
        assert (this.checkTxCount(0, 1, 0));
        assert (this.checkTxCount(1, 0, 1));
        assert (this.checkTxCount(2, 0, 1));
        this.tm(0).begin();
        this.cache(0).put((Object)"k0", (Object)"other");
        try {
            this.tm(0).commit();
            assert (false);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockReplOptTest.this.checkTxCount(0, 1, 0) && BasicSingleLockReplOptTest.this.checkTxCount(1, 0, 1) && BasicSingleLockReplOptTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.tm(1).begin();
        this.cache(1).put((Object)"k0", (Object)"other");
        try {
            this.tm(1).commit();
            assert (false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockReplOptTest.this.checkTxCount(0, 1, 0) && BasicSingleLockReplOptTest.this.checkTxCount(1, 0, 1) && BasicSingleLockReplOptTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.tm(0).resume((Transaction)dtm);
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertValue("k0", false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockReplOptTest.this.noPendingTransactions(0) && BasicSingleLockReplOptTest.this.noPendingTransactions(1) && BasicSingleLockReplOptTest.this.noPendingTransactions(2);
            }
        });
    }
}

