/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.AsyncAPISyncReplTest")
public class AsyncAPITxSyncReplTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = this.getConfig();
        c.fluent().transaction().autoCommit(false);
        this.createClusteredCaches(2, c);
    }

    protected Configuration getConfig() {
        return AsyncAPITxSyncReplTest.getDefaultClusteredConfig(this.sync() ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC, true);
    }

    protected boolean sync() {
        return true;
    }

    protected void asyncWait(boolean tx, Class<? extends WriteCommand> ... cms) {
    }

    protected void assertOnAllCaches(Key k, String v, Cache c1, Cache c2) {
        Object real;
        assert (Util.safeEquals((Object)(real = c1.get((Object)k)), (Object)v)) : "Error on cache 1.  Expected " + v + " and got " + real;
        assert (Util.safeEquals((Object)(real = c2.get((Object)k)), (Object)v)) : "Error on cache 2.  Expected " + v + " and got " + real;
    }

    public void testAsyncTxMethods() throws Exception {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(1);
        String v = "v";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        String v5 = "v5";
        String v6 = "v6";
        String v_null = "v_nonexistent";
        Key key = new Key("k", false);
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        NotifyingFuture f = c1.putAsync((Object)key, (Object)v);
        assert (f != null);
        assert (f.isDone());
        Transaction t = tm.suspend();
        assert (c2.get((Object)key) == null);
        tm.resume(t);
        assert (f.get() == null);
        tm.commit();
        this.asyncWait(true, PutKeyValueCommand.class);
        this.assertOnAllCaches(key, v, c1, c2);
        tm.begin();
        f = c1.putAsync((Object)key, (Object)v2);
        assert (f != null);
        assert (f.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v));
        tm.resume(t);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v));
        tm.commit();
        this.asyncWait(true, PutKeyValueCommand.class);
        this.assertOnAllCaches(key, v2, c1, c2);
        tm.begin();
        NotifyingFuture f2 = c1.putAllAsync(Collections.singletonMap(key, v3));
        assert (f2 != null);
        assert (f2.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v2));
        tm.resume(t);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        tm.commit();
        this.asyncWait(true, PutMapCommand.class);
        this.assertOnAllCaches(key, v3, c1, c2);
        tm.begin();
        f = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f != null);
        assert (f.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v3));
        tm.resume(t);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v3));
        tm.commit();
        this.assertOnAllCaches(key, v3, c1, c2);
        tm.begin();
        f = c1.removeAsync((Object)key);
        assert (f != null);
        assert (f.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v3));
        tm.resume(t);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v3));
        tm.commit();
        this.asyncWait(true, RemoveCommand.class);
        this.assertOnAllCaches(key, null, c1, c2);
        tm.begin();
        f = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f != null);
        assert (f.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key) == null);
        tm.resume(t);
        assert (!f.isCancelled());
        assert (f.get() == null);
        tm.commit();
        this.asyncWait(true, PutKeyValueCommand.class);
        this.assertOnAllCaches(key, v4, c1, c2);
        tm.begin();
        NotifyingFuture f3 = c1.removeAsync((Object)key, (Object)v_null);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        tm.commit();
        this.assertOnAllCaches(key, v4, c1, c2);
        tm.begin();
        f3 = c1.removeAsync((Object)key, (Object)v4);
        assert (f3 != null);
        assert (f3.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v4));
        tm.resume(t);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        tm.commit();
        this.asyncWait(true, RemoveCommand.class);
        this.assertOnAllCaches(key, null, c1, c2);
        tm.begin();
        f = c1.replaceAsync((Object)key, (Object)v5);
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        tm.commit();
        this.assertOnAllCaches(key, null, c1, c2);
        tm.begin();
        c1.put((Object)key, (Object)v);
        tm.commit();
        this.asyncWait(true, PutKeyValueCommand.class);
        tm.begin();
        f = c1.replaceAsync((Object)key, (Object)v5);
        assert (f != null);
        assert (f.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v));
        tm.resume(t);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v));
        tm.commit();
        this.asyncWait(true, ReplaceCommand.class);
        this.assertOnAllCaches(key, v5, c1, c2);
        tm.begin();
        f3 = c1.replaceAsync((Object)key, (Object)v_null, (Object)v6);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        tm.commit();
        this.assertOnAllCaches(key, v5, c1, c2);
        tm.begin();
        f3 = c1.replaceAsync((Object)key, (Object)v5, (Object)v6);
        assert (f3 != null);
        assert (f3.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v5));
        tm.resume(t);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        tm.commit();
        this.asyncWait(true, ReplaceCommand.class);
        this.assertOnAllCaches(key, v6, c1, c2);
    }
}

