/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.RndKeyGenerator;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class MultipleCacheManagersTest
extends AbstractCacheTest {
    protected List<EmbeddedCacheManager> cacheManagers = new ArrayList<EmbeddedCacheManager>();
    protected IdentityHashMap<Cache, ReplListener> listeners = new IdentityHashMap();

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        if (this.cleanupAfterTest()) {
            this.callCreateCacheManagers();
        }
    }

    private void callCreateCacheManagers() throws Throwable {
        try {
            this.log.debug((Object)"Creating cache managers");
            this.createCacheManagers();
            this.log.debug((Object)"Cache managers created, ready to start the test");
        }
        catch (Throwable th) {
            this.log.error((Object)"Error in test setup: ", th);
            throw th;
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.cleanupAfterMethod()) {
            this.callCreateCacheManagers();
        }
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        if (this.cleanupAfterTest()) {
            TestingUtil.killCacheManagers(this.cacheManagers);
        }
        this.cacheManagers.clear();
        this.listeners.clear();
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (this.cleanupAfterTest()) {
            this.log.debug((Object)"*** Test method complete; clearing contents on all caches.");
            if (this.cacheManagers.isEmpty()) {
                throw new IllegalStateException("No caches registered! Use registerCacheManager(Cache... caches) to do that!");
            }
            TestingUtil.clearContent(this.cacheManagers);
        } else {
            TestingUtil.killCacheManagers(this.cacheManagers);
            this.cacheManagers.clear();
        }
    }

    protected void assertSupportedConfig() {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            for (Cache cache : TestingUtil.getRunningCaches(cm)) {
                Configuration config = cache.getConfiguration();
                try {
                    assert (config.isSyncCommitPhase()) : "Must use a sync commit phase!";
                    assert (config.isSyncRollbackPhase()) : "Must use a sync rollback phase!";
                }
                catch (AssertionError e) {
                    this.log.error((Object)("Invalid config for cache in test: " + this.getClass().getName()));
                    throw e;
                }
            }
        }
    }

    protected final void registerCacheManager(CacheContainer ... cacheContainers) {
        for (CacheContainer ecm : cacheContainers) {
            this.cacheManagers.add((EmbeddedCacheManager)ecm);
        }
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager() {
        return this.addClusterEnabledCacheManager(new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(flags);
        this.cacheManagers.add(cm);
        return cm;
    }

    @Deprecated
    protected EmbeddedCacheManager addClusterEnabledCacheManager(Configuration defaultConfig) {
        return this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder defaultConfig) {
        return this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags());
    }

    @Deprecated
    protected EmbeddedCacheManager addClusterEnabledCacheManager(Configuration defaultConfig, TransportFlags flags) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(defaultConfig, flags);
        this.cacheManagers.add(cm);
        return cm;
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder builder, TransportFlags flags) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(builder, flags);
        this.cacheManagers.add(cm);
        return cm;
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(Configuration.CacheMode mode, boolean transactional) {
        return this.addClusterEnabledCacheManager(mode, transactional, new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(Configuration.CacheMode mode, boolean transactional, TransportFlags flags) {
        Configuration configuration = MultipleCacheManagersTest.getDefaultClusteredConfig(mode, transactional);
        return this.addClusterEnabledCacheManager(configuration, flags);
    }

    protected void createCluster(Configuration.CacheMode mode, boolean transactional, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(mode, transactional);
        }
    }

    protected void createCluster(ConfigurationBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(builder);
        }
    }

    protected void createCluster(Configuration config, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(config);
        }
    }

    protected void createCluster(Configuration.CacheMode mode, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(mode, true);
        }
    }

    protected void defineConfigurationOnAllManagers(String cacheName, Configuration c) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            cm.defineConfiguration(cacheName, c);
        }
    }

    protected void defineConfigurationOnAllManagers(String cacheName, ConfigurationBuilder b) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            cm.defineConfiguration(cacheName, b.build());
        }
    }

    private List<Cache> getCaches(String cacheName) {
        ArrayList<Cache> caches = new ArrayList<Cache>();
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            caches.add(cacheName == null ? cm.getCache() : cm.getCache(cacheName));
        }
        return caches;
    }

    protected void waitForClusterToForm(String cacheName) {
        List<Cache> caches = this.getCaches(cacheName);
        Cache cache = caches.get(0);
        TestingUtil.blockUntilViewsReceived(10000, caches);
        if (cache.getConfiguration().getCacheMode().isDistributed()) {
            TestingUtil.waitForRehashToComplete(caches);
        }
    }

    protected void waitForClusterToForm() {
        this.waitForClusterToForm((String)null);
    }

    protected void waitForClusterToForm(String ... names) {
        for (String name : names) {
            this.waitForClusterToForm(name);
        }
    }

    protected TransactionManager tm(Cache<?, ?> c) {
        return c.getAdvancedCache().getTransactionManager();
    }

    protected TransactionManager tm(int i, String cacheName) {
        return this.cache(i, cacheName).getAdvancedCache().getTransactionManager();
    }

    protected TransactionManager tm(int i) {
        return this.cache(i).getAdvancedCache().getTransactionManager();
    }

    protected Transaction tx(int i) {
        try {
            return this.cache(i).getAdvancedCache().getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String cacheName, Configuration c) {
        return this.createClusteredCaches(numMembersInCluster, cacheName, c, new TransportFlags());
    }

    protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String cacheName, ConfigurationBuilder builder) {
        return this.createClusteredCaches(numMembersInCluster, cacheName, builder, new TransportFlags());
    }

    @Deprecated
    protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String cacheName, Configuration c, TransportFlags flags) {
        ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>(numMembersInCluster);
        for (int i = 0; i < numMembersInCluster; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(flags);
            cm.defineConfiguration(cacheName, c);
            Cache cache = cm.getCache(cacheName);
            caches.add(cache);
        }
        this.waitForClusterToForm(cacheName);
        return caches;
    }

    protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String cacheName, ConfigurationBuilder builder, TransportFlags flags) {
        ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>(numMembersInCluster);
        for (int i = 0; i < numMembersInCluster; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(flags);
            cm.defineConfiguration(cacheName, builder.build());
            Cache cache = cm.getCache(cacheName);
            caches.add(cache);
        }
        this.waitForClusterToForm(cacheName);
        return caches;
    }

    protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, Configuration defaultConfig) {
        ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>(numMembersInCluster);
        for (int i = 0; i < numMembersInCluster; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(defaultConfig);
            Cache cache = cm.getCache();
            caches.add(cache);
        }
        this.waitForClusterToForm();
        return caches;
    }

    protected ReplListener replListener(Cache cache) {
        ReplListener listener = this.listeners.get(cache);
        if (listener == null) {
            listener = new ReplListener(cache);
            this.listeners.put(cache, listener);
        }
        return listener;
    }

    protected EmbeddedCacheManager manager(int i) {
        return this.cacheManagers.get(i);
    }

    protected <K, V> Cache<K, V> cache(int managerIndex, String cacheName) {
        return this.manager(managerIndex).getCache(cacheName);
    }

    protected void assertClusterSize(String message, int size) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            assert (cm.getMembers() != null && cm.getMembers().size() == size) : message;
        }
    }

    protected void removeCacheFromCluster(String cacheName) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            TestingUtil.killCaches(cm.getCache(cacheName));
        }
    }

    protected <A, B> Cache<A, B> cache(int index) {
        return this.manager(index).getCache();
    }

    protected abstract void createCacheManagers() throws Throwable;

    protected Address address(int cacheIndex) {
        return this.manager(cacheIndex).getAddress();
    }

    protected AdvancedCache advancedCache(int i) {
        return this.cache(i).getAdvancedCache();
    }

    protected AdvancedCache advancedCache(int i, String cacheName) {
        return this.cache(i, cacheName).getAdvancedCache();
    }

    protected <K, V> List<Cache<K, V>> caches(String name) {
        ArrayList<Cache<K, V>> result = new ArrayList<Cache<K, V>>();
        for (EmbeddedCacheManager ecm : this.cacheManagers) {
            Cache c = name == null ? ecm.getCache() : ecm.getCache(name);
            result.add(c);
        }
        return result;
    }

    protected <K, V> List<Cache<K, V>> caches() {
        return this.caches(null);
    }

    protected Address address(Cache c) {
        return c.getAdvancedCache().getRpcManager().getAddress();
    }

    protected LockManager lockManager(int i) {
        return TestingUtil.extractLockManager(this.cache(i));
    }

    protected LockManager lockManager(int i, String cacheName) {
        return TestingUtil.extractLockManager(this.getCache(i, cacheName));
    }

    public List<EmbeddedCacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    protected void killMember(int cacheIndex) {
        List caches = this.caches();
        caches.remove(cacheIndex);
        this.manager(cacheIndex).stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, caches.toArray(new Cache[0]));
    }

    protected Object getKeyForCache(int nodeIndex) {
        Cache cache = this.cache(nodeIndex);
        return this.getKeyForCache(cache);
    }

    protected Object getKeyForCache(int nodeIndex, String cacheName) {
        Cache cache = this.cache(nodeIndex, cacheName);
        return this.getKeyForCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getKeyForCache(Cache cache) {
        ExecutorService ex = Executors.newSingleThreadExecutor();
        KeyAffinityService kas = KeyAffinityServiceFactory.newKeyAffinityService((Cache)cache, (Executor)ex, (KeyGenerator)new RndKeyGenerator(), (int)5, (boolean)true);
        try {
            Object object = kas.getKeyForAddress(cache.getAdvancedCache().getRpcManager().getAddress());
            return object;
        }
        finally {
            ex.shutdown();
        }
    }

    protected void assertNotLocked(final String cacheName, final Object key) {
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                boolean aNodeIsLocked = false;
                for (int i = 0; i < MultipleCacheManagersTest.this.caches(cacheName).size(); ++i) {
                    boolean isLocked = MultipleCacheManagersTest.this.lockManager(i, cacheName).isLocked(key);
                    if (isLocked) {
                        MultipleCacheManagersTest.this.log.trace((Object)(key + " is locked on cache index " + i + " by " + MultipleCacheManagersTest.this.lockManager(i, cacheName).getOwner(key)));
                    }
                    aNodeIsLocked = aNodeIsLocked || isLocked;
                }
                return !aNodeIsLocked;
            }
        });
    }

    protected void assertNotLocked(Object key) {
        this.assertNotLocked((String)null, key);
    }

    protected boolean checkTxCount(int cacheIndex, int localTx, int remoteTx) {
        int localTxCount = TestingUtil.getTransactionTable(this.cache(cacheIndex)).getLocalTxCount();
        int remoteTxCount = TestingUtil.getTransactionTable(this.cache(cacheIndex)).getRemoteTxCount();
        this.log.tracef("Cache index %s, local tx %4s, remote tx %4s \n", (Object)cacheIndex, (Object)localTxCount, (Object)remoteTxCount);
        return localTxCount == localTx && remoteTxCount == remoteTx;
    }

    protected void assertNotLocked(int cacheIndex, Object key) {
        this.assertNotLocked(this.cache(cacheIndex), key);
    }

    protected void assertLocked(int cacheIndex, Object key) {
        this.assertLocked(this.cache(cacheIndex), key);
    }

    protected boolean checkLocked(int index, Object key) {
        return this.checkLocked(this.cache(index), key);
    }

    protected Cache getLockOwner(Object key) {
        return this.getLockOwner(key, null);
    }

    protected Cache getLockOwner(Object key, String cacheName) {
        Configuration c = this.getCache(0, cacheName).getConfiguration();
        if (c.getCacheMode().isReplicated() || c.getCacheMode().isInvalidation()) {
            return this.getCache(0, cacheName);
        }
        if (!c.getCacheMode().isDistributed()) {
            throw new IllegalStateException("This is not a clustered cache!");
        }
        Address address = (Address)this.getCache(0, cacheName).getAdvancedCache().getDistributionManager().locate(key).get(0);
        for (Cache cache : this.caches(cacheName)) {
            if (!cache.getAdvancedCache().getRpcManager().getTransport().getAddress().equals(address)) continue;
            return cache;
        }
        throw new IllegalStateException();
    }

    protected void assertKeyLockedCorrectly(Object key) {
        this.assertKeyLockedCorrectly(key, null);
    }

    protected void assertKeyLockedCorrectly(Object key, String cacheName) {
        Cache lockOwner = this.getLockOwner(key, cacheName);
        assert (this.checkLocked(lockOwner, key));
        for (Cache c : this.caches(cacheName)) {
            if (c != lockOwner) assert (!this.checkLocked(c, key)) : "Key " + key + " is locked on cache " + c + " (" + cacheName + ") and it shouldn't";
        }
    }

    private Cache getCache(int index, String name) {
        return name == null ? this.cache(index) : this.cache(index, name);
    }

    protected void forceTwoPhase(int cacheIndex) throws SystemException, RollbackException {
        TransactionManager tm = this.tm(cacheIndex);
        Transaction tx = tm.getTransaction();
        tx.enlistResource((XAResource)new XAResourceAdapter());
    }
}

