/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.synchronisation;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.infinispan.config.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.tx.LocalModeTxTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.synchronization.LocalModeWithSyncTxTest")
public class LocalModeWithSyncTxTest
extends LocalModeTxTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() {
        Configuration config = this.getDefaultStandaloneConfig(true);
        config.fluent().transaction().transactionManagerLookupClass(DummyTransactionManagerLookup.class);
        config.fluent().transaction().useSynchronization(Boolean.valueOf(true));
        return new DefaultCacheManager(config);
    }

    public void testSyncRegisteredWithCommit() throws Exception {
        DummyTransaction dt = this.startTx();
        this.tm().commit();
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)0, (int)dt.getEnlistedSynchronization().size());
        Assert.assertEquals((Object)"v", (Object)this.cache.get((Object)"k"));
    }

    public void testSyncRegisteredWithRollback() throws Exception {
        DummyTransaction dt = this.startTx();
        this.tm().rollback();
        Assert.assertEquals(null, (Object)this.cache.get((Object)"k"));
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)0, (int)dt.getEnlistedSynchronization().size());
    }

    private DummyTransaction startTx() throws NotSupportedException, SystemException {
        this.tm().begin();
        this.cache.put((Object)"k", (Object)"v");
        DummyTransaction dt = (DummyTransaction)this.tm().getTransaction();
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)1, (int)dt.getEnlistedSynchronization().size());
        this.cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)1, (int)dt.getEnlistedSynchronization().size());
        return dt;
    }
}

