/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.protocols.BasicTCP;

@Experimental
@Unsupported
public class TCP_NIO
extends BasicTCP
implements BasicConnectionTable.Receiver {
    @Property
    private int reader_threads = 3;
    @Property
    private int writer_threads = 3;
    @Property
    private int processor_threads = 5;
    @Property
    private int processor_minThreads = 5;
    @Property
    private int processor_maxThreads = 5;
    @Property
    private int processor_queueSize = 100;
    @Property
    private long processor_keepAliveTime = Long.MAX_VALUE;
    private ConnectionTableNIO ct;

    protected ConnectionTableNIO getConnectionTable(long ri, long cet, InetAddress b_addr, InetAddress bc_addr, int s_port, int e_port) throws Exception {
        ConnectionTableNIO retval = null;
        if (ri == 0L && cet == 0L) {
            retval = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port, false);
        } else {
            if (ri == 0L) {
                ri = 5000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn("reaper_interval was 0, set it to " + ri);
                }
            }
            if (cet == 0L) {
                cet = 300000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn("conn_expire_time was 0, set it to " + cet);
                }
            }
            retval = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port, ri, cet, false);
        }
        retval.setThreadFactory(this.getThreadFactory());
        retval.setProcessorMaxThreads(this.getProcessorMaxThreads());
        retval.setProcessorQueueSize(this.getProcessorQueueSize());
        retval.setProcessorMinThreads(this.getProcessorMinThreads());
        retval.setProcessorKeepAliveTime(this.getProcessorKeepAliveTime());
        retval.setProcessorThreads(this.getProcessorThreads());
        retval.start();
        return retval;
    }

    @Override
    public String printConnections() {
        return this.ct.toString();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.ct != null ? (PhysicalAddress)this.ct.getLocalAddress() : null;
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        this.ct.send(dest, data, offset, length);
    }

    @Override
    public void start() throws Exception {
        this.ct = this.getConnectionTable(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.bind_port, this.bind_port + this.port_range);
        this.ct.setUseSendQueues(this.use_send_queues);
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.ct.setPeerAddressReadTimeout(this.peer_addr_read_timeout);
        this.ct.setTcpNodelay(this.tcp_nodelay);
        this.ct.setLinger(this.linger);
        super.start();
    }

    @Override
    public void retainAll(Collection<Address> members) {
        this.ct.retainAll(members);
    }

    @Override
    public void stop() {
        this.ct.stop();
        super.stop();
    }

    public int getReaderThreads() {
        return this.reader_threads;
    }

    public int getWriterThreads() {
        return this.writer_threads;
    }

    public int getProcessorThreads() {
        return this.processor_threads;
    }

    public int getProcessorMinThreads() {
        return this.processor_minThreads;
    }

    public int getProcessorMaxThreads() {
        return this.processor_maxThreads;
    }

    public int getProcessorQueueSize() {
        return this.processor_queueSize;
    }

    public long getProcessorKeepAliveTime() {
        return this.processor_keepAliveTime;
    }

    @ManagedAttribute
    public int getOpenConnections() {
        return this.ct.getNumConnections();
    }
}

