/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.TextExtractors;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStoreException;

@ThreadSafe
public interface BinaryStore {
    public long getMinimumBinarySizeInBytes();

    public void setMinimumBinarySizeInBytes(long var1);

    public void setTextExtractors(TextExtractors var1);

    public void setMimeTypeDetector(MimeTypeDetector var1);

    public BinaryValue storeValue(InputStream var1) throws BinaryStoreException;

    public InputStream getInputStream(BinaryKey var1) throws BinaryStoreException;

    public void markAsUnused(Iterable<BinaryKey> var1) throws BinaryStoreException;

    public void removeValuesUnusedLongerThan(long var1, TimeUnit var3) throws BinaryStoreException;

    public String getText(BinaryValue var1) throws BinaryStoreException;

    public String getMimeType(BinaryValue var1, String var2) throws IOException, RepositoryException;

    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException;
}

