/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.BsonUtils;
import org.infinispan.schematic.internal.document.DefaultDocumentValueFactory;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;

public class ArrayEditor
implements EditableArray {
    private static final long serialVersionUID = 1L;
    private final MutableArray array;
    private final DocumentValueFactory factory;

    public ArrayEditor(MutableArray array, DocumentValueFactory factory) {
        assert (array != null);
        this.array = array;
        this.factory = factory != null ? factory : DefaultDocumentValueFactory.INSTANCE;
    }

    @Override
    public ArrayEditor clone() {
        return new ArrayEditor((MutableArray)this.array.clone(), this.factory);
    }

    @Override
    public ArrayEditor with(Map<String, Object> changedFields) {
        return new ArrayEditor((MutableArray)this.array.with(changedFields), this.factory);
    }

    @Override
    public ArrayEditor with(Document.ValueTransformer transformer) {
        return new ArrayEditor((MutableArray)this.array.with(transformer), this.factory);
    }

    @Override
    public Document withVariablesReplaced(Properties properties) {
        return new ArrayEditor((MutableArray)this.array.withVariablesReplaced(properties), this.factory);
    }

    @Override
    public Document withVariablesReplacedWithSystemProperties() {
        return new ArrayEditor((MutableArray)this.array.withVariablesReplacedWithSystemProperties(), this.factory);
    }

    @Override
    public Array unwrap() {
        return this.array;
    }

    public MutableArray asMutableArray() {
        return this.array;
    }

    @Override
    public Object get(String name) {
        return this.array.get(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.array.getBoolean(name);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.array.getBoolean(name, defaultValue);
    }

    public Object put(String name, Object value) {
        return this.array.put(name, value);
    }

    @Override
    public void putAll(Document object) {
        this.array.putAll(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.array.putAll(map);
    }

    @Override
    public Object remove(String name) {
        return this.array.remove(name);
    }

    @Override
    public Integer getInteger(String name) {
        return this.array.getInteger(name);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        return this.array.getInteger(name, defaultValue);
    }

    @Override
    public Long getLong(String name) {
        return this.array.getLong(name);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        return this.array.getLong(name, defaultValue);
    }

    @Override
    public Double getDouble(String name) {
        return this.array.getDouble(name);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        return this.array.getDouble(name, defaultValue);
    }

    @Override
    public Number getNumber(String name) {
        return this.array.getNumber(name);
    }

    @Override
    public Number getNumber(String name, Number defaultValue) {
        return this.array.getNumber(name, defaultValue);
    }

    @Override
    public String getString(String name) {
        return this.array.getString(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.array.getString(name, defaultValue);
    }

    @Override
    public EditableArray getArray(String name) {
        return this.editable(this.array.getArray(name), this.indexFrom(name));
    }

    @Override
    public EditableArray getOrCreateArray(String name) {
        List<?> existing = this.array.getArray(name);
        return existing != null ? this.editable(existing, this.indexFrom(name)) : this.setArray(name);
    }

    @Override
    public EditableDocument getDocument(String name) {
        return this.editable(this.array.getDocument(name), this.indexFrom(name));
    }

    @Override
    public EditableDocument getOrCreateDocument(String name) {
        Document existing = this.array.getDocument(name);
        return existing != null ? this.editable(existing, this.indexFrom(name)) : this.setDocument(name);
    }

    @Override
    public boolean isNull(String name) {
        return this.array.isNull(name);
    }

    @Override
    public boolean isNullOrMissing(String name) {
        return this.array.isNullOrMissing(name);
    }

    @Override
    public MaxKey getMaxKey(String name) {
        return this.array.getMaxKey(name);
    }

    @Override
    public MinKey getMinKey(String name) {
        return this.array.getMinKey(name);
    }

    @Override
    public Code getCode(String name) {
        return this.array.getCode(name);
    }

    @Override
    public CodeWithScope getCodeWithScope(String name) {
        return this.array.getCodeWithScope(name);
    }

    @Override
    public ObjectId getObjectId(String name) {
        return this.array.getObjectId(name);
    }

    @Override
    public Binary getBinary(String name) {
        return this.array.getBinary(name);
    }

    @Override
    public Symbol getSymbol(String name) {
        return this.array.getSymbol(name);
    }

    @Override
    public Pattern getPattern(String name) {
        return this.array.getPattern(name);
    }

    @Override
    public UUID getUuid(String name) {
        return this.array.getUuid(name);
    }

    @Override
    public UUID getUuid(String name, UUID defaultValue) {
        return this.array.getUuid(name, defaultValue);
    }

    @Override
    public int getType(String name) {
        return this.array.getType(name);
    }

    @Override
    public Map<String, ? extends Object> toMap() {
        return this.array.toMap();
    }

    @Override
    public Iterable<Document.Field> fields() {
        return this.array.fields();
    }

    @Override
    public boolean containsField(String name) {
        return this.array.containsField(name);
    }

    @Override
    public boolean containsAll(Document document) {
        return this.array.containsAll(document);
    }

    @Override
    public Set<String> keySet() {
        return this.array.keySet();
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public void removeAll() {
        this.array.removeAll();
    }

    @Override
    public EditableArray setBoolean(String name, boolean value) {
        return this.setValue(name, (Object)this.factory.createBoolean(value));
    }

    @Override
    public EditableArray setNumber(String name, int value) {
        return this.setValue(name, (Object)this.factory.createInt(value));
    }

    @Override
    public EditableArray setNumber(String name, long value) {
        return this.setValue(name, (Object)this.factory.createLong(value));
    }

    @Override
    public EditableArray setNumber(String name, float value) {
        return this.setValue(name, (Object)this.factory.createDouble(value));
    }

    @Override
    public EditableArray setNumber(String name, double value) {
        return this.setValue(name, (Object)this.factory.createDouble(value));
    }

    @Override
    public EditableArray setString(String name, String value) {
        return this.setValue(name, (Object)this.factory.createString(value));
    }

    @Override
    public EditableArray setSymbol(String name, String value) {
        return this.setValue(name, (Object)this.factory.createSymbol(value));
    }

    @Override
    public EditableDocument setDocument(String name) {
        BasicDocument doc = new BasicDocument();
        this.setValue(name, (Object)doc);
        return this.editable(doc, this.indexFrom(name));
    }

    @Override
    public EditableDocument setDocument(String name, Document document) {
        if (document instanceof DocumentEditor) {
            document = ((DocumentEditor)document).unwrap();
        }
        this.setValue(name, (Object)document);
        return this.editable(document, this.indexFrom(name));
    }

    @Override
    public EditableArray setArray(String name) {
        BasicArray array = new BasicArray();
        this.setValue(name, (Object)array);
        return this.editable(array, this.indexFrom(name));
    }

    @Override
    public EditableArray setArray(String name, Array array) {
        this.setValue(name, (Object)array);
        return this.editable(array, this.indexFrom(name));
    }

    @Override
    public EditableArray setArray(String name, Object ... values) {
        this.setValue(name, Arrays.asList(values));
        return this.editable(this.array, this.indexFrom(name));
    }

    @Override
    public EditableArray setDate(String name, Date value) {
        return this.setValue(name, (Object)value);
    }

    @Override
    public EditableArray setDate(String name, String isoDate) throws ParseException {
        return this.setValue(name, (Object)this.factory.createDate(isoDate));
    }

    @Override
    public EditableArray setTimestamp(String name, int timeInSeconds, int increment) {
        return this.setValue(name, (Object)this.factory.createTimestamp(timeInSeconds, increment));
    }

    @Override
    public EditableArray setObjectId(String name, String hex) {
        return this.setValue(name, (Object)this.factory.createObjectId(hex));
    }

    @Override
    public EditableArray setObjectId(String name, byte[] bytes) {
        return this.setValue(name, (Object)this.factory.createObjectId(bytes));
    }

    @Override
    public EditableArray setObjectId(String name, int time, int machine, int process, int inc) {
        return this.setValue(name, (Object)this.factory.createObjectId(time, machine, process, inc));
    }

    @Override
    public EditableArray setRegularExpression(String name, String pattern) {
        return this.setValue(name, (Object)this.factory.createRegex(pattern, null));
    }

    @Override
    public EditableArray setRegularExpression(String name, String pattern, int flags) {
        return this.setValue(name, (Object)this.factory.createRegex(pattern, BsonUtils.regexFlagsFor(flags)));
    }

    @Override
    public EditableArray setNull(String name) {
        return this.setValue(name, this.factory.createNull());
    }

    @Override
    public EditableArray setBinary(String name, byte type, byte[] data) {
        return this.setValue(name, (Object)this.factory.createBinary(type, data));
    }

    @Override
    public EditableArray setUuid(String name, UUID uuid) {
        return this.setValue(name, (Object)uuid);
    }

    @Override
    public EditableDocument setCode(String name, String code, boolean includeScope) {
        if (includeScope) {
            BasicDocument scope = new BasicDocument();
            this.setValue(name, (Object)this.factory.createCode(code, scope));
            return this.editable(scope, this.indexFrom(name));
        }
        return this.setValue(name, (Object)this.factory.createCode(code));
    }

    @Override
    public EditableDocument setCode(String name, String code, Document scope) {
        if (scope != null) {
            this.setValue(name, (Object)this.factory.createCode(code, scope));
            return this.editable(scope, this.indexFrom(name));
        }
        return this.setValue(name, (Object)this.factory.createCode(code));
    }

    protected EditableArray setValue(String name, Object value) {
        this.doSetValue(name, value);
        return this;
    }

    @Override
    public EditableArray setValue(int index, Object value) {
        this.doSetValue(index, value);
        return this;
    }

    @Override
    public EditableArray addValue(Object value) {
        this.doAddValue(value);
        return this;
    }

    @Override
    public EditableArray addValueIfAbsent(Object value) {
        this.doAddValueIfAbsent(value);
        return this;
    }

    @Override
    public EditableArray addValue(int index, Object value) {
        this.doAddValue(index, value);
        return this;
    }

    protected final int indexFrom(String name) {
        return Integer.parseInt(name);
    }

    protected Object doSetValue(String name, Object value) {
        int index = this.indexFrom(name);
        return this.doSetValue(index, value);
    }

    protected Object doSetValue(int index, Object value) {
        value = ArrayEditor.unwrap(value);
        return this.array.setValue(index, value);
    }

    protected int doAddValue(Object value) {
        value = ArrayEditor.unwrap(value);
        return this.array.addValue(value);
    }

    protected void doAddValue(int index, Object value) {
        value = ArrayEditor.unwrap(value);
        this.array.addValue(index, value);
    }

    protected boolean doAddValueIfAbsent(Object value) {
        value = ArrayEditor.unwrap(value);
        return this.array.addValueIfAbsent(value);
    }

    protected boolean doRemoveValue(Object value) {
        value = ArrayEditor.unwrap(value);
        return this.array.removeValue(value);
    }

    protected Object doRemoveValue(int index) {
        return this.array.removeValue(index);
    }

    protected boolean doAddAll(Collection<? extends Object> c) {
        return this.array.addAllValues(c);
    }

    protected boolean doAddAll(int index, Collection<? extends Object> c) {
        return this.array.addAllValues(index, c);
    }

    protected List<Array.Entry> doRemoveAll(Collection<?> c) {
        return this.array.removeAllValues(c);
    }

    protected List<Array.Entry> doRetainAll(Collection<?> c) {
        return this.array.retainAllValues(c);
    }

    protected void doClear() {
        this.array.removeAll();
    }

    protected EditableDocument editable(Document doc, int index) {
        if (doc == null) {
            return null;
        }
        assert (!(doc instanceof DocumentEditor)) : "The document value should not be a DocumentEditor instance";
        if (doc instanceof MutableArray) {
            return this.createEditableArray((MutableArray)doc, index, this.factory);
        }
        assert (doc instanceof MutableDocument);
        return this.createEditableDocument((MutableDocument)doc, index, this.factory);
    }

    protected EditableArray editable(List<?> array, int index) {
        if (array == null) {
            return null;
        }
        assert (!(array instanceof ArrayEditor)) : "The array value should not be an ArrayEditor instance";
        return this.createEditableArray((BasicArray)array, index, this.factory);
    }

    private EditableArray editableSublist(List<?> sublist) {
        assert (sublist != null);
        if (sublist instanceof EditableArray) {
            return (EditableArray)((Object)this.array);
        }
        return this.createEditableSublist((BasicArray)sublist, this.factory);
    }

    protected EditableDocument createEditableDocument(MutableDocument document, int index, DocumentValueFactory factory) {
        return new DocumentEditor(document, factory);
    }

    protected EditableArray createEditableArray(MutableArray array, int index, DocumentValueFactory factory) {
        return new ArrayEditor(array, factory);
    }

    protected EditableArray createEditableSublist(MutableArray array, DocumentValueFactory factory) {
        return new ArrayEditor(array, factory);
    }

    public static Array unwrap(Array array) {
        if (array instanceof ArrayEditor) {
            return ArrayEditor.unwrap(((ArrayEditor)array).unwrap());
        }
        return array;
    }

    public static Document unwrap(Document document) {
        if (document instanceof DocumentEditor) {
            return ArrayEditor.unwrap(((DocumentEditor)document).unwrap());
        }
        return document;
    }

    public static Object unwrap(Object value) {
        if (value instanceof DocumentEditor) {
            return ArrayEditor.unwrap(((DocumentEditor)value).unwrap());
        }
        if (value instanceof ArrayEditor) {
            return ArrayEditor.unwrap(((ArrayEditor)value).unwrap());
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.array.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.array.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.array.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.array.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        return this.doAddValue(e) != -1;
    }

    @Override
    public boolean remove(Object o) {
        return this.doRemoveValue(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.array.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return this.doAddAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.doAddAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        List<Array.Entry> removed = this.doRemoveAll(c);
        return !removed.isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List<Array.Entry> removed = this.doRetainAll(c);
        return !removed.isEmpty();
    }

    @Override
    public void clear() {
        this.doClear();
    }

    @Override
    public Object get(int index) {
        Object value = this.array.get(index);
        if (value instanceof Document) {
            value = this.editable((Document)value, index);
        } else if (value instanceof List) {
            value = this.editable((List)value, index);
        }
        return value;
    }

    @Override
    public Object set(int index, Object element) {
        return this.doSetValue(index, element);
    }

    @Override
    public void add(int index, Object element) {
        this.doAddValue(index, element);
    }

    @Override
    public Object remove(int index) {
        return this.doRemoveValue(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.array.lastIndexOf(o);
    }

    @Override
    public Iterable<Array.Entry> getEntries() {
        return this.array.getEntries();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.array.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.array.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.editableSublist(this.array.subList(fromIndex, toIndex));
    }

    @Override
    public EditableArray set(String name, Object value) {
        return this.setValue(name, value);
    }

    @Override
    public EditableArray setBoolean(int index, boolean value) {
        return this.setValue(index, (Object)this.factory.createBoolean(value));
    }

    @Override
    public EditableArray setNumber(int index, int value) {
        return this.setValue(index, (Object)this.factory.createInt(value));
    }

    @Override
    public EditableArray setNumber(int index, long value) {
        return this.setValue(index, (Object)this.factory.createLong(value));
    }

    @Override
    public EditableArray setNumber(int index, float value) {
        return this.setValue(index, (Object)this.factory.createDouble(value));
    }

    @Override
    public EditableArray setNumber(int index, double value) {
        return this.setValue(index, (Object)this.factory.createDouble(value));
    }

    @Override
    public EditableArray setString(int index, String value) {
        return this.setValue(index, (Object)this.factory.createString(value));
    }

    @Override
    public EditableArray setSymbol(int index, String value) {
        return this.setValue(index, (Object)this.factory.createSymbol(value));
    }

    @Override
    public EditableDocument setDocument(int index) {
        BasicDocument doc = new BasicDocument();
        this.setValue(index, (Object)doc);
        return this.editable(doc, index);
    }

    @Override
    public EditableDocument setDocument(int index, Document document) {
        if (document instanceof DocumentEditor) {
            document = ((DocumentEditor)document).unwrap();
        }
        this.setValue(index, (Object)document);
        return this.editable(document, index);
    }

    @Override
    public EditableArray setArray(int index) {
        BasicArray array = new BasicArray();
        this.setValue(index, (Object)array);
        return this.editable(array, index);
    }

    @Override
    public EditableArray setArray(int index, Array array) {
        this.setValue(index, (Object)array);
        return this.editable(array, index);
    }

    @Override
    public EditableArray setDate(int index, Date value) {
        this.setValue(index, (Object)value);
        return this;
    }

    @Override
    public EditableArray setDate(int index, String isoDate) throws ParseException {
        this.setValue(index, (Object)this.factory.createDate(isoDate));
        return this;
    }

    @Override
    public EditableArray setTimestamp(int index, int timeInSeconds, int increment) {
        return this.setValue(index, (Object)this.factory.createTimestamp(timeInSeconds, increment));
    }

    @Override
    public EditableArray setObjectId(int index, String hex) {
        return this.setValue(index, (Object)this.factory.createObjectId(hex));
    }

    @Override
    public EditableArray setObjectId(int index, byte[] bytes) {
        return this.setValue(index, (Object)this.factory.createObjectId(bytes));
    }

    @Override
    public EditableArray setObjectId(int index, int time, int machine, int process, int inc) {
        return this.setValue(index, (Object)this.factory.createObjectId(time, machine, process, inc));
    }

    @Override
    public EditableArray setRegularExpression(int index, String pattern) {
        return this.setValue(index, (Object)this.factory.createRegex(pattern, null));
    }

    @Override
    public EditableArray setRegularExpression(int index, String pattern, int flags) {
        return this.setValue(index, (Object)this.factory.createRegex(pattern, flags));
    }

    @Override
    public EditableArray setNull(int index) {
        return this.setValue(index, this.factory.createNull());
    }

    @Override
    public EditableArray setBinary(int index, byte type, byte[] data) {
        return this.setValue(index, (Object)this.factory.createBinary(type, data));
    }

    @Override
    public EditableArray setUuid(int index, UUID uuid) {
        return this.setValue(index, (Object)uuid);
    }

    @Override
    public EditableDocument setCode(int index, String code, boolean includeScope) {
        if (includeScope) {
            BasicDocument scope = new BasicDocument();
            this.setValue(index, (Object)this.factory.createCode(code, scope));
            return this.editable(scope, index);
        }
        return this.setValue(index, (Object)this.factory.createCode(code));
    }

    @Override
    public EditableDocument setCode(int index, String code, Document scope) {
        if (scope != null) {
            this.setValue(index, (Object)this.factory.createCode(code, scope));
            return this.editable(scope, index);
        }
        return this.setValue(index, (Object)this.factory.createCode(code));
    }

    @Override
    public EditableArray addBoolean(int index, boolean value) {
        return this.addValue(index, this.factory.createBoolean(value));
    }

    @Override
    public EditableArray addNumber(int index, int value) {
        return this.addValue(index, this.factory.createInt(value));
    }

    @Override
    public EditableArray addNumber(int index, long value) {
        return this.addValue(index, this.factory.createLong(value));
    }

    @Override
    public EditableArray addNumber(int index, float value) {
        return this.addValue(index, this.factory.createDouble(value));
    }

    @Override
    public EditableArray addNumber(int index, double value) {
        return this.addValue(index, this.factory.createDouble(value));
    }

    @Override
    public EditableArray addString(int index, String value) {
        return this.addValue(index, this.factory.createString(value));
    }

    @Override
    public EditableArray addSymbol(int index, String value) {
        return this.addValue(index, this.factory.createSymbol(value));
    }

    @Override
    public EditableDocument addDocument(int index) {
        BasicDocument doc = new BasicDocument();
        this.addValue(index, doc);
        return this.editable(doc, index);
    }

    @Override
    public EditableDocument addDocument(int index, Document document) {
        if (document instanceof DocumentEditor) {
            document = ((DocumentEditor)document).unwrap();
        }
        this.addValue(index, document);
        return this.editable(document, index);
    }

    @Override
    public EditableArray addArray(int index) {
        BasicArray array = new BasicArray();
        this.addValue(index, array);
        return this.editable(array, index);
    }

    @Override
    public EditableArray addArray(int index, Array array) {
        this.addValue(index, array);
        return this.editable(array, index);
    }

    @Override
    public EditableArray addDate(int index, Date value) {
        this.addValue(index, value);
        return this;
    }

    @Override
    public EditableArray addDate(int index, String isoDate) throws ParseException {
        this.addValue(index, this.factory.createDate(isoDate));
        return this;
    }

    @Override
    public EditableArray addTimestamp(int index, int timeInSeconds, int increment) {
        return this.addValue(index, this.factory.createTimestamp(timeInSeconds, increment));
    }

    @Override
    public EditableArray addObjectId(int index, String hex) {
        return this.addValue(index, this.factory.createObjectId(hex));
    }

    @Override
    public EditableArray addObjectId(int index, byte[] bytes) {
        return this.addValue(index, this.factory.createObjectId(bytes));
    }

    @Override
    public EditableArray addObjectId(int index, int time, int machine, int process, int inc) {
        return this.addValue(index, this.factory.createObjectId(time, machine, process, inc));
    }

    @Override
    public EditableArray addRegularExpression(int index, String pattern) {
        return this.addValue(index, this.factory.createRegex(pattern, null));
    }

    @Override
    public EditableArray addRegularExpression(int index, String pattern, int flags) {
        return this.addValue(index, this.factory.createRegex(pattern, flags));
    }

    @Override
    public EditableArray addNull(int index) {
        return this.addValue(index, this.factory.createNull());
    }

    @Override
    public EditableArray addBinary(int index, byte type, byte[] data) {
        return this.addValue(index, this.factory.createBinary(type, data));
    }

    @Override
    public EditableArray addUuid(int index, UUID uuid) {
        return this.addValue(index, uuid);
    }

    @Override
    public EditableDocument addCode(int index, String code, boolean includeScope) {
        if (includeScope) {
            BasicDocument scope = new BasicDocument();
            this.addValue(index, this.factory.createCode(code, scope));
            return this.editable(scope, index);
        }
        return this.addValue(index, this.factory.createCode(code));
    }

    @Override
    public EditableDocument addCode(int index, String code, Document scope) {
        if (scope != null) {
            this.addValue(index, this.factory.createCode(code, scope));
            return this.editable(scope, index);
        }
        return this.addValue(index, this.factory.createCode(code));
    }

    @Override
    public EditableArray addBoolean(boolean value) {
        return this.addValue(this.factory.createBoolean(value));
    }

    @Override
    public EditableArray addNumber(int value) {
        return this.addValue(this.factory.createInt(value));
    }

    @Override
    public EditableArray addNumber(long value) {
        return this.addValue(this.factory.createLong(value));
    }

    @Override
    public EditableArray addNumber(float value) {
        return this.addValue(this.factory.createDouble(value));
    }

    @Override
    public EditableArray addNumber(double value) {
        return this.addValue(this.factory.createDouble(value));
    }

    @Override
    public EditableArray addString(String value) {
        return this.addValue(this.factory.createString(value));
    }

    @Override
    public EditableArray addSymbol(String value) {
        return this.addValue(this.factory.createSymbol(value));
    }

    @Override
    public EditableDocument addDocument() {
        BasicDocument doc = new BasicDocument();
        this.addValue(doc);
        return this.editable(doc, this.size());
    }

    @Override
    public EditableDocument addDocument(Document document) {
        if (document instanceof DocumentEditor) {
            document = ((DocumentEditor)document).unwrap();
        }
        this.addValue(document);
        return this.editable(document, this.size());
    }

    @Override
    public EditableArray addArray() {
        BasicArray array = new BasicArray();
        this.addValue(array);
        return this.editable(array, this.size());
    }

    @Override
    public EditableArray addArray(Array array) {
        this.addValue(array);
        return this.editable(array, this.size());
    }

    @Override
    public EditableArray addDate(Date value) {
        return this.addValue(value);
    }

    @Override
    public EditableArray addDate(String isoDate) throws ParseException {
        return this.addValue(this.factory.createDate(isoDate));
    }

    @Override
    public EditableArray addTimestamp(int timeInSeconds, int increment) {
        return this.addValue(this.factory.createTimestamp(timeInSeconds, increment));
    }

    @Override
    public EditableArray addObjectId(String hex) {
        return this.addValue(this.factory.createObjectId(hex));
    }

    @Override
    public EditableArray addObjectId(byte[] bytes) {
        return this.addValue(this.factory.createObjectId(bytes));
    }

    @Override
    public EditableArray addObjectId(int time, int machine, int process, int inc) {
        return this.addValue(this.factory.createObjectId(time, machine, process, inc));
    }

    @Override
    public EditableArray addRegularExpression(String pattern) {
        return this.addValue(this.factory.createRegex(pattern, null));
    }

    @Override
    public EditableArray addRegularExpression(String pattern, int flags) {
        return this.addValue(this.factory.createRegex(pattern, flags));
    }

    @Override
    public EditableArray addNull() {
        return this.addValue(this.factory.createNull());
    }

    @Override
    public EditableArray addBinary(byte type, byte[] data) {
        return this.addValue(this.factory.createBinary(type, data));
    }

    @Override
    public EditableArray addUuid(UUID uuid) {
        return this.addValue(uuid);
    }

    @Override
    public EditableDocument addCode(String code, boolean includeScope) {
        if (includeScope) {
            BasicDocument scope = new BasicDocument();
            this.addValue(this.factory.createCode(code, scope));
            return this.editable(scope, this.size());
        }
        return this.addValue(this.factory.createCode(code));
    }

    @Override
    public EditableDocument addCode(String code, Document scope) {
        if (scope != null) {
            this.addValue(this.factory.createCode(code, scope));
            return this.editable(scope, this.size());
        }
        return this.addValue(this.factory.createCode(code));
    }

    @Override
    public EditableArray addBooleanIfAbsent(boolean value) {
        return this.addValueIfAbsent(this.factory.createBoolean(value));
    }

    @Override
    public EditableArray addNumberIfAbsent(int value) {
        return this.addValueIfAbsent(this.factory.createInt(value));
    }

    @Override
    public EditableArray addNumberIfAbsent(long value) {
        return this.addValueIfAbsent(this.factory.createLong(value));
    }

    @Override
    public EditableArray addNumberIfAbsent(float value) {
        return this.addValueIfAbsent(this.factory.createDouble(value));
    }

    @Override
    public EditableArray addNumberIfAbsent(double value) {
        return this.addValueIfAbsent(this.factory.createDouble(value));
    }

    @Override
    public EditableArray addStringIfAbsent(String value) {
        return this.addValueIfAbsent(this.factory.createString(value));
    }

    @Override
    public EditableArray addSymbolIfAbsent(String value) {
        return this.addValueIfAbsent(this.factory.createSymbol(value));
    }

    @Override
    public EditableDocument addDocumentIfAbsent(Document document) {
        if (document instanceof DocumentEditor) {
            document = ((DocumentEditor)document).unwrap();
        }
        return this.doAddValueIfAbsent(document) ? this.editable(document, this.size()) : null;
    }

    @Override
    public EditableArray addArrayIfAbsent(Array array) {
        return this.doAddValueIfAbsent(array) ? this.editable(array, this.size()) : null;
    }

    @Override
    public EditableArray addDateIfAbsent(Date value) {
        return this.addValueIfAbsent(value);
    }

    @Override
    public EditableArray addDateIfAbsent(String isoDate) throws ParseException {
        return this.addValueIfAbsent(this.factory.createDate(isoDate));
    }

    @Override
    public EditableArray addTimestampIfAbsent(int timeInSeconds, int increment) {
        return this.addValueIfAbsent(this.factory.createTimestamp(timeInSeconds, increment));
    }

    @Override
    public EditableArray addObjectIdIfAbsent(String hex) {
        return this.addValueIfAbsent(this.factory.createObjectId(hex));
    }

    @Override
    public EditableArray addObjectIdIfAbsent(byte[] bytes) {
        return this.addValueIfAbsent(this.factory.createObjectId(bytes));
    }

    @Override
    public EditableArray addObjectIdIfAbsent(int time, int machine, int process, int inc) {
        return this.addValueIfAbsent(this.factory.createObjectId(time, machine, process, inc));
    }

    @Override
    public EditableArray addRegularExpressionIfAbsent(String pattern) {
        return this.addValueIfAbsent(this.factory.createRegex(pattern, null));
    }

    @Override
    public EditableArray addRegularExpressionIfAbsent(String pattern, int flags) {
        return this.addValueIfAbsent(this.factory.createRegex(pattern, flags));
    }

    @Override
    public EditableArray addNullIfAbsent() {
        return this.addValueIfAbsent(this.factory.createNull());
    }

    @Override
    public EditableArray addBinaryIfAbsent(byte type, byte[] data) {
        return this.addValueIfAbsent(this.factory.createBinary(type, data));
    }

    @Override
    public EditableArray addUuidIfAbsent(UUID uuid) {
        return this.addValueIfAbsent(uuid);
    }

    @Override
    public EditableDocument addCodeIfAbsent(String code, Document scope) {
        if (scope != null) {
            return this.doAddValueIfAbsent(this.factory.createCode(code, scope)) ? this.editable(scope, this.size()) : null;
        }
        return this.addValueIfAbsent(this.factory.createCode(code));
    }

    public String toString() {
        return this.array.toString();
    }
}

