/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import javax.jcr.Node;
import javax.jcr.Value;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.model.ModelObjectHandler;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public final class TransformationModelObjectHandler
extends ModelObjectHandler {
    @Override
    protected void process(XmiElement element, Node parentNode) throws Exception {
        CheckArg.isNotNull((Object)element, (String)"element");
        CheckArg.isNotNull((Object)parentNode, (String)"node");
        CheckArg.isEquals((Object)element.getNamespaceUri(), (String)"namespace URI", (Object)"http://www.metamatrix.com/metamodels/Transformation", (String)"relational URI");
        this.debug("==== TransformationModelObjectHandler:process:element=" + element.getName());
        if ("TransformationContainer".equals(element.getName())) {
            for (XmiElement kid : element.getChildren()) {
                if ("transformationMappings".equals(kid.getName())) {
                    this.processMappings(kid);
                    continue;
                }
                this.debug("**** transformation container child of '" + kid.getName() + "' was not processed");
            }
        } else {
            this.debug("**** transformation type of '" + element.getName() + "' was not processed");
        }
    }

    private void processInputs(XmiElement inputs, Node transformed, ReferenceResolver.UnresolvedReference unresolved) throws Exception {
        assert (inputs != null);
        assert ("inputs".equals(inputs.getName()));
        ReferenceResolver resolver = this.getResolver();
        String inputHref = inputs.getAttributeValue("href", "http://www.metamatrix.com/metamodels/Transformation");
        String inputUuid = resolver.resolveInternalReference(inputHref);
        this.setReference(transformed, unresolved, "transform:transformedFrom", inputUuid, true);
        if (transformed != null) {
            this.addPropertyValue(transformed, "transform:transformedFromHrefs", inputHref);
        } else if (unresolved != null) {
            unresolved.addProperty("transform:transformedFromHrefs", inputHref, true);
        } else assert (false);
        if (transformed != null) {
            this.addPropertyValue(transformed, "transform:transformedFromXmiUuids", inputUuid);
        } else if (unresolved != null) {
            unresolved.addProperty("transform:transformedFromXmiUuids", inputUuid, true);
        } else assert (false);
        Node source = resolver.getNode(inputUuid);
        if (transformed != null && source != null) {
            this.addPropertyValue(transformed, "transform:transformedFromNames", source.getName());
        } else {
            String referencerUuid = null;
            if (unresolved != null) {
                referencerUuid = unresolved.getUuid();
            } else if (transformed != null) {
                referencerUuid = transformed.getProperty("xmi:uuid").getString();
            } else assert (false);
            if (source == null) {
                ReferenceResolver.UnresolvedReference unresolvedSource = resolver.addUnresolvedReference(inputUuid);
                unresolvedSource.addResolvedName(referencerUuid, "transform:transformedFromNames");
            } else if (unresolved != null) {
                unresolved.addProperty("transform:transformedFromNames", source.getName(), true);
            } else assert (false);
        }
    }

    private void processMappings(XmiElement mappings) throws Exception {
        assert (mappings != null);
        assert ("transformationMappings".equals(mappings.getName()));
        this.debug("=========" + mappings.getName());
        ReferenceResolver resolver = this.getResolver();
        String targetUuid = mappings.getAttributeValue("target", "http://www.metamatrix.com/metamodels/Transformation");
        String uuid = resolver.resolveInternalReference(targetUuid);
        Node targetNode = resolver.getNode(uuid);
        ReferenceResolver.UnresolvedReference unresolved = null;
        if (targetNode == null) {
            unresolved = resolver.addUnresolvedReference(uuid);
            unresolved.addMixin("transform:withSql");
            unresolved.addMixin("transform:transformed");
        } else if (!targetNode.isNodeType("transform:withSql")) {
            targetNode.addMixin("transform:withSql");
            targetNode.addMixin("transform:transformed");
        }
        for (XmiElement kid : mappings.getChildren()) {
            if ("helper".equals(kid.getName())) {
                XmiElement helperNested = kid.findChild("nested", "http://www.metamatrix.com/metamodels/Transformation");
                if (helperNested == null) continue;
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:selectSql", "selectSql");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:insertSql", "insertSql");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:updateSql", "updateSql");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:deleteSql", "deleteSql");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:insertAllowed", "insertAllowed");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:updateAllowed", "updateAllowed");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:deleteAllowed", "deleteAllowed");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:insertSqlDefault", "insertSql");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:updateSqlDefault", "updateSql");
                this.setNestedProperty(targetNode, unresolved, helperNested, "transform:deleteSqlDefault", "deleteSql");
                continue;
            }
            if ("inputs".equals(kid.getName())) {
                this.processInputs(kid, targetNode, unresolved);
                continue;
            }
            if ("nested".equals(kid.getName())) {
                this.processNested(kid);
                continue;
            }
            this.debug("**** transformation mapping child type of " + kid + " was not processed");
        }
    }

    private void processNested(XmiElement nested) throws Exception {
        assert (nested != null);
        assert ("nested".equals(nested.getName()));
        ReferenceResolver resolver = this.getResolver();
        String columnHref = nested.getAttributeValue("outputs", "http://www.metamatrix.com/metamodels/Transformation");
        String columnUuid = resolver.resolveInternalReference(columnHref);
        Node columnNode = resolver.getNode(columnUuid);
        ReferenceResolver.UnresolvedReference unresolvedColumn = null;
        if (columnNode == null) {
            unresolvedColumn = resolver.addUnresolvedReference(columnUuid);
            unresolvedColumn.addMixin("transform:transformed");
        } else if (!columnNode.isNodeType("transform:transformed")) {
            columnNode.addMixin("transform:transformed");
        }
        for (XmiElement inputs : nested.getChildren()) {
            if (!"inputs".equals(inputs.getName())) continue;
            this.processInputs(inputs, columnNode, unresolvedColumn);
        }
    }

    private void setNestedProperty(Node targetNode, ReferenceResolver.UnresolvedReference unresolved, XmiElement nested, String propertyName, String attributeName) throws Exception {
        assert (nested != null);
        assert (propertyName != null && !propertyName.isEmpty());
        assert (attributeName != null && !attributeName.isEmpty());
        String value = nested.getAttributeValue(attributeName, "http://www.metamatrix.com/metamodels/Transformation");
        if (!StringUtil.isBlank((String)value)) {
            if (targetNode == null) {
                unresolved.addProperty(propertyName, value, false);
            } else {
                this.setProperty(targetNode, propertyName, value);
            }
        }
    }

    private void setReference(Node referencerNode, ReferenceResolver.UnresolvedReference unresolvedReferencer, String propertyName, String referencedUuid, boolean multiValuedProperty) throws Exception {
        assert (referencerNode != null || unresolvedReferencer != null);
        assert (propertyName != null && !propertyName.isEmpty());
        assert (referencedUuid != null && !referencedUuid.isEmpty());
        ReferenceResolver resolver = this.getResolver();
        Node referencedNode = resolver.getNode(referencedUuid);
        ReferenceResolver.UnresolvedReference unresolvedReference = null;
        if (unresolvedReferencer != null) {
            unresolvedReferencer.addReference(propertyName, referencedUuid);
        } else {
            assert (referencerNode != null);
            if (referencedNode == null) {
                unresolvedReference = resolver.addUnresolvedReference(referencedUuid);
                unresolvedReference.addReferencerReference(referencerNode.getProperty("xmi:uuid").getString(), propertyName);
            } else {
                if (!referencedNode.isNodeType("mix:referenceable")) {
                    referencedNode.addMixin("mix:referenceable");
                }
                Value weakRef = referencerNode.getSession().getValueFactory().createValue(referencedNode, true);
                if (multiValuedProperty) {
                    Value[] currentValues = null;
                    Value[] newValues = null;
                    if (referencedNode.hasProperty(propertyName)) {
                        currentValues = referencedNode.getProperty(propertyName).getValues();
                        newValues = new Value[currentValues.length + 1];
                        System.arraycopy(currentValues, 0, newValues, 0, currentValues.length);
                        newValues[currentValues.length] = weakRef;
                    } else {
                        newValues = new Value[]{weakRef};
                    }
                    referencedNode.setProperty(propertyName, newValues);
                } else {
                    referencerNode.setProperty(propertyName, weakRef);
                }
            }
        }
    }
}

