/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.internal.document.BsonUtils;

public class MergeDocument
implements Document {
    private static final long serialVersionUID = 1L;
    private final Document doc1;
    private final Document doc2;

    public MergeDocument(Document document1, Document document2) {
        this.doc1 = document1;
        this.doc2 = document2;
    }

    public MergeDocument(Document document1, Document document2, Document document3) {
        this.doc1 = document1;
        this.doc2 = new MergeDocument(document2, document3);
    }

    @Override
    public MergeDocument clone() {
        return new MergeDocument(this.doc1.clone(), this.doc2.clone());
    }

    @Override
    public MergeDocument with(Map<String, Object> changedFields) {
        Document clone1 = this.doc1.with(changedFields);
        Document clone2 = this.doc2.with(changedFields);
        if (clone1 == this.doc1 && clone2 == this.doc2) {
            return this;
        }
        return new MergeDocument(clone1, clone2);
    }

    @Override
    public Document with(Document.ValueTransformer transformer) {
        Document clone1 = this.doc1.with(transformer);
        Document clone2 = this.doc2.with(transformer);
        if (clone1 == this.doc1 && clone2 == this.doc2) {
            return this;
        }
        return new MergeDocument(clone1, clone2);
    }

    @Override
    public Document withVariablesReplaced(Properties properties) {
        Document clone1 = this.doc1.withVariablesReplaced(properties);
        Document clone2 = this.doc2.withVariablesReplaced(properties);
        if (clone1 == this.doc1 && clone2 == this.doc2) {
            return this;
        }
        return new MergeDocument(clone1, clone2);
    }

    @Override
    public Document withVariablesReplacedWithSystemProperties() {
        Document clone1 = this.doc1.withVariablesReplacedWithSystemProperties();
        Document clone2 = this.doc2.withVariablesReplacedWithSystemProperties();
        if (clone1 == this.doc1 && clone2 == this.doc2) {
            return this;
        }
        return new MergeDocument(clone1, clone2);
    }

    @Override
    public Object get(String name) {
        Object result = this.doc1.get(name);
        return result != null ? result : this.doc2.get(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        Boolean result = this.doc1.getBoolean(name);
        return result != null ? result : this.doc2.getBoolean(name);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Boolean result = this.doc1.getBoolean(name);
        return result != null ? result.booleanValue() : this.doc2.getBoolean(name, defaultValue);
    }

    @Override
    public Integer getInteger(String name) {
        Integer result = this.doc1.getInteger(name);
        return result != null ? result : this.doc2.getInteger(name);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        Integer result = this.doc1.getInteger(name);
        return result != null ? result.intValue() : this.doc2.getInteger(name, defaultValue);
    }

    @Override
    public Long getLong(String name) {
        Long result = this.doc1.getLong(name);
        return result != null ? result : this.doc2.getLong(name);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Long result = this.doc1.getLong(name);
        return result != null ? result.longValue() : this.doc2.getLong(name, defaultValue);
    }

    @Override
    public Double getDouble(String name) {
        Double result = this.doc1.getDouble(name);
        return result != null ? result : this.doc2.getDouble(name);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Double result = this.doc1.getDouble(name);
        return result != null ? result.doubleValue() : this.doc2.getDouble(name, defaultValue);
    }

    @Override
    public Number getNumber(String name) {
        Number result = this.doc1.getNumber(name);
        return result != null ? (Number)result : (Number)this.doc2.getNumber(name);
    }

    @Override
    public Number getNumber(String name, Number defaultValue) {
        Number result = this.doc1.getNumber(name);
        return result != null ? (Number)result : (Number)this.doc2.getNumber(name, defaultValue);
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        String result = this.doc1.getString(name);
        return result != null ? result : this.doc2.getString(name, defaultValue);
    }

    @Override
    public List<?> getArray(String name) {
        List<?> result = this.doc1.getArray(name);
        return result != null ? result : this.doc2.getArray(name);
    }

    @Override
    public Document getDocument(String name) {
        Document result1 = this.doc1.getDocument(name);
        Document result2 = this.doc2.getDocument(name);
        if (result1 == null) {
            return result2;
        }
        return result2 != null ? new MergeDocument(result1, result2) : result1;
    }

    @Override
    public boolean isNull(String name) {
        return this.doc1.isNull(name) && this.doc2.isNull(name);
    }

    @Override
    public boolean isNullOrMissing(String name) {
        return this.doc1.isNullOrMissing(name) && this.doc2.isNullOrMissing(name);
    }

    @Override
    public MaxKey getMaxKey(String name) {
        MaxKey result = this.doc1.getMaxKey(name);
        return result != null ? result : this.doc2.getMaxKey(name);
    }

    @Override
    public MinKey getMinKey(String name) {
        MinKey result = this.doc1.getMinKey(name);
        return result != null ? result : this.doc2.getMinKey(name);
    }

    @Override
    public Code getCode(String name) {
        Code result = this.doc1.getCode(name);
        return result != null ? result : this.doc2.getCode(name);
    }

    @Override
    public CodeWithScope getCodeWithScope(String name) {
        CodeWithScope result = this.doc1.getCodeWithScope(name);
        return result != null ? result : this.doc2.getCodeWithScope(name);
    }

    @Override
    public ObjectId getObjectId(String name) {
        ObjectId result = this.doc1.getObjectId(name);
        return result != null ? result : this.doc2.getObjectId(name);
    }

    @Override
    public Binary getBinary(String name) {
        Binary result = this.doc1.getBinary(name);
        return result != null ? result : this.doc2.getBinary(name);
    }

    @Override
    public Symbol getSymbol(String name) {
        Symbol result = this.doc1.getSymbol(name);
        return result != null ? result : this.doc2.getSymbol(name);
    }

    @Override
    public Pattern getPattern(String name) {
        Pattern result = this.doc1.getPattern(name);
        return result != null ? result : this.doc2.getPattern(name);
    }

    @Override
    public UUID getUuid(String name) {
        UUID result = this.doc1.getUuid(name);
        return result != null ? result : this.doc2.getUuid(name);
    }

    @Override
    public UUID getUuid(String name, UUID defaultValue) {
        UUID result = this.doc1.getUuid(name);
        return result != null ? result : this.doc2.getUuid(name, defaultValue);
    }

    @Override
    public int getType(String name) {
        int type = this.doc1.getType(name);
        return type > -1 ? type : this.doc2.getType(name);
    }

    @Override
    public Map<String, ? extends Object> toMap() {
        HashMap<String, ? extends Object> result = new HashMap<String, Object>(this.doc2.toMap());
        result.putAll(this.doc1.toMap());
        return result;
    }

    @Override
    public Iterable<Document.Field> fields() {
        if (this.doc1.isEmpty()) {
            return this.doc2.fields();
        }
        if (this.doc2.isEmpty()) {
            return this.doc1.fields();
        }
        final Iterator<Document.Field> iter1 = this.doc1.fields().iterator();
        final Iterator<Document.Field> iter2 = this.doc2.fields().iterator();
        return new Iterable<Document.Field>(){

            @Override
            public Iterator<Document.Field> iterator() {
                return new Iterator<Document.Field>(){
                    private boolean first = true;

                    @Override
                    public boolean hasNext() {
                        boolean result = false;
                        if (this.first) {
                            result = iter1.hasNext();
                            if (result) {
                                return result;
                            }
                            this.first = false;
                        }
                        return iter2.hasNext();
                    }

                    @Override
                    public Document.Field next() {
                        return this.first ? (Document.Field)iter1.next() : (Document.Field)iter2.next();
                    }

                    @Override
                    public void remove() {
                        if (this.first) {
                            iter1.remove();
                        } else {
                            iter2.remove();
                        }
                    }
                };
            }
        };
    }

    @Override
    public boolean containsField(String name) {
        return this.doc1.containsField(name) || this.doc2.containsField(name);
    }

    @Override
    public boolean containsAll(Document document) {
        if (document == null) {
            return true;
        }
        for (Document.Field field : document.fields()) {
            Object thatValue;
            Object thisValue = this.get(field.getName());
            if (BsonUtils.valuesAreEqual(thisValue, thatValue = field.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.doc1.keySet());
        keys.addAll(this.doc2.keySet());
        return keys;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.doc1.isEmpty() && this.doc2.isEmpty();
    }
}

