/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.schematic.DocumentLibrary;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.InMemoryDocumentLibrary;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.schematic.internal.schema.DocumentTransformer;
import org.infinispan.schematic.internal.schema.SchemaDocument;
import org.infinispan.schematic.internal.schema.SchemaDocumentCache;
import org.infinispan.schematic.internal.schema.ValidationResult;
import org.infinispan.util.concurrent.NotifyingFuture;

public class InMemorySchemaLibrary
implements SchemaLibrary,
Lifecycle {
    private final DocumentLibrary documents;
    private final SchemaDocumentCache schemaDocuments;

    public InMemorySchemaLibrary(String name) {
        this.documents = new InMemoryDocumentLibrary(name);
        this.schemaDocuments = new SchemaDocumentCache(this, null);
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public String getName() {
        return this.documents.getName();
    }

    @Override
    public Document get(String key) {
        return this.documents.get(key);
    }

    @Override
    public Document put(String key, Document document) {
        Document result = this.documents.put(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public Document putIfAbsent(String key, Document document) {
        Document result = this.documents.putIfAbsent(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public Document replace(String key, Document document) {
        Document result = this.documents.replace(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public Document remove(String key) {
        Document result = this.documents.remove(key);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public NotifyingFuture<Document> getAsync(String key) {
        return this.documents.getAsync(key);
    }

    @Override
    public NotifyingFuture<Document> putAsync(String key, Document document) {
        NotifyingFuture<Document> result = this.documents.putAsync(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public NotifyingFuture<Document> putIfAbsentAsync(String key, Document document) {
        NotifyingFuture<Document> result = this.documents.putIfAbsentAsync(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public NotifyingFuture<Document> replaceAsync(String key, Document document) {
        NotifyingFuture<Document> result = this.documents.replaceAsync(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public NotifyingFuture<Document> removeAsync(String key) {
        NotifyingFuture<Document> result = this.documents.removeAsync(key);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public SchemaLibrary.Results validate(Document document, String schemaUri) {
        ValidationResult result = new ValidationResult();
        SchemaDocument schema = this.schemaDocuments.get(schemaUri, result);
        if (schema != null) {
            schema.getValidator().validate(null, null, document, Paths.rootPath(), result, this.schemaDocuments);
        }
        return result;
    }

    @Override
    public Document convertValues(Document document, SchemaLibrary.Results results) {
        return DocumentTransformer.convertValuesWithMismatchedTypes(document, results);
    }

    @Override
    public Document convertValues(Document document, String schemaUri) {
        SchemaLibrary.Results results = this.validate(document, schemaUri);
        return this.convertValues(document, results);
    }
}

