/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.modeshape.web.jcr.rest.model.RestProperty;

public final class RestNode
extends RestItem {
    private final List<RestProperty> jcrProperties = new ArrayList<RestProperty>();
    private final List<RestNode> children = new ArrayList<RestNode>();
    private final Map<String, String> customProperties = new TreeMap<String, String>();

    public RestNode(String name, String url, String parentUrl) {
        super(name, url, parentUrl);
    }

    public RestNode addChild(RestNode child) {
        this.children.add(child);
        return this;
    }

    public RestNode addJcrProperty(RestProperty property) {
        this.jcrProperties.add(property);
        return this;
    }

    public RestNode addCustomProperty(String name, String value) {
        this.customProperties.put(name, value);
        return this;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject node = new JSONObject();
        node.put("self", (Object)this.url);
        node.put("up", (Object)this.parentUrl);
        this.addCustomProperties(node);
        this.addJcrProperties(node);
        this.addChildren(node);
        return node;
    }

    private void addChildren(JSONObject node) throws JSONException {
        if (!this.children.isEmpty()) {
            JSONObject children = new JSONObject();
            for (RestNode child : this.children) {
                children.put(child.name, (Object)child.toJSON());
            }
            node.put("children", (Object)children);
        }
    }

    private void addJcrProperties(JSONObject node) throws JSONException {
        for (RestProperty restProperty : this.jcrProperties) {
            if (restProperty.isMultiValue()) {
                node.put(restProperty.name, restProperty.getValues());
                continue;
            }
            if (restProperty.getValue() == null) continue;
            node.put(restProperty.name, (Object)restProperty.getValue());
        }
    }

    private void addCustomProperties(JSONObject node) throws JSONException {
        for (String customPropertyName : this.customProperties.keySet()) {
            node.put(customPropertyName, (Object)this.customProperties.get(customPropertyName));
        }
    }
}

