/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.util.List;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class Fill {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    public static final int FILL_SOLID = 0;
    public static final int FILL_PATTERN = 1;
    public static final int FILL_TEXTURE = 2;
    public static final int FILL_PICTURE = 3;
    public static final int FILL_SHADE = 4;
    public static final int FILL_SHADE_CENTER = 5;
    public static final int FILL_SHADE_SHAPE = 6;
    public static final int FILL_SHADE_SCALE = 7;
    public static final int FILL_SHADE_TITLE = 8;
    public static final int FILL_BACKGROUND = 9;
    protected Shape shape;

    public Fill(Shape shape) {
        this.shape = shape;
    }

    public int getFillType() {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, 384);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    protected void afterInsert(Sheet sh) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)Shape.getEscherProperty(opt, 390);
        if (p != null) {
            int idx = p.getPropertyValue();
            EscherBSERecord bse = this.getEscherBSERecord(idx);
            bse.setRef(bse.getRef() + 1);
        }
    }

    protected EscherBSERecord getEscherBSERecord(int idx) {
        Sheet sheet = this.shape.getSheet();
        if (sheet == null) {
            this.logger.log(POILogger.DEBUG, (Object)"Fill has not yet been assigned to a sheet");
            return null;
        }
        SlideShow ppt = sheet.getSlideShow();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            this.logger.log(POILogger.DEBUG, (Object)"EscherContainerRecord.BSTORE_CONTAINER was not found ");
            return null;
        }
        List lst = bstore.getChildRecords();
        return (EscherBSERecord)lst.get(idx - 1);
    }

    public void setFillType(int type) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        Shape.setEscherProperty(opt, (short)384, type);
    }

    public Color getForegroundColor() {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)Shape.getEscherProperty(opt, 447);
        if (p != null && (p.getPropertyValue() & 0x10) == 0) {
            return null;
        }
        return this.shape.getColor((short)385, (short)386, -1);
    }

    public void setForegroundColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        if (color == null) {
            Shape.setEscherProperty(opt, (short)447, 0x150000);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            Shape.setEscherProperty(opt, (short)385, rgb);
            Shape.setEscherProperty(opt, (short)447, 0x150011);
        }
    }

    public Color getBackgroundColor() {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)Shape.getEscherProperty(opt, 447);
        if (p != null && (p.getPropertyValue() & 0x10) == 0) {
            return null;
        }
        return this.shape.getColor((short)387, (short)386, -1);
    }

    public void setBackgroundColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        if (color == null) {
            Shape.setEscherProperty(opt, (short)387, -1);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            Shape.setEscherProperty(opt, (short)387, rgb);
        }
    }

    public PictureData getPictureData() {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)Shape.getEscherProperty(opt, 390);
        if (p == null) {
            return null;
        }
        SlideShow ppt = this.shape.getSheet().getSlideShow();
        PictureData[] pict = ppt.getPictureData();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        List lst = bstore.getChildRecords();
        int idx = p.getPropertyValue();
        if (idx == 0) {
            this.logger.log(POILogger.WARN, (Object)"no reference to picture data found ");
        } else {
            EscherBSERecord bse = (EscherBSERecord)lst.get(idx - 1);
            for (int i = 0; i < pict.length; ++i) {
                if (pict[i].getOffset() != bse.getOffset()) continue;
                return pict[i];
            }
        }
        return null;
    }

    public void setPictureData(int idx) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this.shape.getSpContainer(), -4085);
        Shape.setEscherProperty(opt, (short)16774, idx);
        if (idx != 0 && this.shape.getSheet() != null) {
            EscherBSERecord bse = this.getEscherBSERecord(idx);
            bse.setRef(bse.getRef() + 1);
        }
    }
}

