/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;

public final class NodeTypesImporter {
    private static final Logger LOGGER = Logger.getLogger(NodeTypesImporter.class);
    private final JcrRepository.RunningState runningState;
    private final List<String> nodeTypesFiles;

    public NodeTypesImporter(List<String> nodeTypesFiles, JcrRepository.RunningState runningState) {
        this.nodeTypesFiles = nodeTypesFiles;
        this.runningState = runningState;
    }

    void importNodeTypes() throws RepositoryException {
        if (this.nodeTypesFiles.isEmpty()) {
            return;
        }
        ArrayList<NodeTypeDefinition> nodeTypeDefinitions = new ArrayList<NodeTypeDefinition>();
        for (String cndFile : this.nodeTypesFiles) {
            nodeTypeDefinitions.addAll(this.parseCNDFile(cndFile));
        }
        if (nodeTypeDefinitions.isEmpty()) {
            return;
        }
        this.runningState.nodeTypeManager().registerNodeTypes(nodeTypeDefinitions, false, false, true);
    }

    private List<NodeTypeDefinition> parseCNDFile(String cndFile) {
        InputStream cndFileStream = this.runningState.environment().getClassLoader(NodeTypesImporter.class.getClassLoader(), new String[0]).getResourceAsStream(cndFile);
        if (cndFileStream == null) {
            LOGGER.warn((I18nResource)JcrI18n.cannotLoadCndFile, new Object[]{cndFile});
            return Collections.emptyList();
        }
        CndImporter cndImporter = new CndImporter(this.runningState.context(), true);
        SimpleProblems importProblems = new SimpleProblems();
        try {
            cndImporter.importFrom(cndFileStream, (Problems)importProblems, cndFile);
            if (importProblems.hasErrors()) {
                importProblems.writeTo(LOGGER);
                return Collections.emptyList();
            }
            return cndImporter.getNodeTypeDefinitions();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.errorReadingCndFile, new Object[]{cndFile});
            return Collections.emptyList();
        }
    }
}

