/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test
public abstract class BaseWordCountMapReduceTest
extends MultipleCacheManagersTest {
    public BaseWordCountMapReduceTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    protected Configuration.CacheMode getCacheMode() {
        return Configuration.CacheMode.DIST_SYNC;
    }

    protected String cacheName() {
        return "mapreducecache";
    }

    private MapReduceTask<String, String, String, Integer> testinvokeMapReduce(String[] keys, Mapper<String, String, String, Integer> mapper, Reducer<String, Integer> reducer) throws Exception {
        Cache c1 = this.cache(0, this.cacheName());
        Cache c2 = this.cache(1, this.cacheName());
        c1.put((Object)"1", (Object)"Hello world here I am");
        c2.put((Object)"2", (Object)"Infinispan rules the world");
        c1.put((Object)"3", (Object)"JUDCon is in Boston");
        c2.put((Object)"4", (Object)"JBoss World is in Boston as well");
        c1.put((Object)"12", (Object)"JBoss Application Server");
        c2.put((Object)"15", (Object)"Hello world");
        c1.put((Object)"14", (Object)"Infinispan community");
        c2.put((Object)"15", (Object)"Hello world");
        c1.put((Object)"111", (Object)"Infinispan open source");
        c2.put((Object)"112", (Object)"Boston is close to Toronto");
        c1.put((Object)"113", (Object)"Toronto is a capital of Ontario");
        c2.put((Object)"114", (Object)"JUDCon is cool");
        c1.put((Object)"211", (Object)"JBoss World is awesome");
        c2.put((Object)"212", (Object)"JBoss rules");
        c1.put((Object)"213", (Object)"JBoss division of RedHat ");
        c2.put((Object)"214", (Object)"RedHat community");
        MapReduceTask task = new MapReduceTask(c1);
        task.mappedWith(mapper).reducedWith(reducer);
        if (keys != null && keys.length > 0) {
            task.onKeys((Object[])keys);
        }
        return task;
    }

    private MapReduceTask<String, String, String, Integer> testinvokeMapReduce(String[] keys) throws Exception {
        return this.testinvokeMapReduce(keys, new WordCountMapper(), new WordCountReducer());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testImproperCacheStateForMapReduceTask() {
        GlobalConfiguration gc = GlobalConfiguration.getNonClusteredDefault();
        Configuration c = new Configuration();
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(gc, c, true);
        Cache cache = defaultCacheManager.getCache();
        MapReduceTask task = new MapReduceTask(cache);
    }

    public void testinvokeMapReduceOnAllKeys() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(null);
        Map mapReduce = task.execute();
        Integer count = (Integer)mapReduce.get("Infinispan");
        assert (count == 3);
        count = (Integer)mapReduce.get("RedHat");
        assert (count == 2);
    }

    public void testMapperReducerIsolation() throws Exception {
        this.testinvokeMapReduce(null, new IsolationMapper(), new IsolationReducer());
    }

    public void testinvokeMapReduceOnAllKeysAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(null);
        Future future = task.executeAsynchronously();
        Map mapReduce = (Map)future.get();
        Integer count = (Integer)mapReduce.get("Infinispan");
        assert (count == 3);
        count = (Integer)mapReduce.get("RedHat");
        assert (count == 2);
    }

    public void testinvokeMapReduceOnSubsetOfKeys() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(new String[]{"1", "2", "3"});
        Map mapReduce = task.execute();
        Integer count = (Integer)mapReduce.get("Infinispan");
        assert (count == 1);
        count = (Integer)mapReduce.get("Boston");
        assert (count == 1);
    }

    public void testinvokeMapReduceOnSubsetOfKeysAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(new String[]{"1", "2", "3"});
        Future future = task.executeAsynchronously();
        Map mapReduce = (Map)future.get();
        Integer count = (Integer)mapReduce.get("Infinispan");
        assert (count == 1);
        count = (Integer)mapReduce.get("Boston");
        assert (count == 1);
    }

    public void testinvokeMapReduceOnAllKeysWithCollator() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(null);
        Integer totalWords = (Integer)task.execute((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        assert (totalWords == 56);
    }

    public void testinvokeMapReduceOnSubsetOfKeysWithCollator() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(new String[]{"1", "2", "3"});
        Integer totalWords = (Integer)task.execute((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        assert (totalWords == 13);
    }

    public void testinvokeMapReduceOnAllKeysWithCollatorAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(null);
        Future future = task.executeAsynchronously((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        Integer totalWords = (Integer)future.get();
        assert (totalWords == 56);
    }

    public void testinvokeMapReduceOnSubsetOfKeysWithCollatorAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.testinvokeMapReduce(new String[]{"1", "2", "3"});
        Future future = task.executeAsynchronously((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        Integer totalWords = (Integer)future.get();
        assert (totalWords == 13);
    }

    private static class IsolationReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 6069777605143824777L;
        private int count = 0;

        private IsolationReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            assert (this.count == 0);
            ++this.count;
            return this.count;
        }
    }

    private static class IsolationMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = 1993535517358319862L;
        private int count = 0;

        private IsolationMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            assert (this.count == 0);
            ++this.count;
        }
    }

    private static class WordCountReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 1901016598354633256L;

        private WordCountReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            int sum = 0;
            while (iter.hasNext()) {
                Integer i = iter.next();
                sum += i.intValue();
            }
            return sum;
        }
    }

    private static class WordCountMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = -5943370243108735560L;

        private WordCountMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreElements()) {
                String s = (String)tokens.nextElement();
                collector.emit((Object)s, (Object)1);
            }
        }
    }
}

