/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.ExecutionException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.AbstractCacheTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSkipRemoteLookupTest")
public class DistSkipRemoteLookupTest
extends BaseDistFunctionalTest {
    public DistSkipRemoteLookupTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testSkipLookupOnGet() {
        MagicKey k1 = new MagicKey(this.c1);
        this.c1.put((Object)k1, (Object)"value");
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        this.assertIsNotInL1(this.c4, k1);
        assert (this.c4.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)k1) == null);
        this.assertOwnershipAndNonOwnership(k1, false);
    }

    public void testCorrectFunctionalityOnConditionalWrite() {
        MagicKey k1 = new MagicKey(this.c1);
        this.c1.put((Object)k1, (Object)"value");
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        this.assertIsNotInL1(this.c4, k1);
        assert (this.c4.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).putIfAbsent((Object)k1, (Object)"new_val") == null);
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        if (this.l1CacheEnabled) {
            this.assertIsInL1(this.c4, k1);
        }
    }

    public void testCorrectFunctionalityOnUnconditionalWrite() {
        MagicKey k1 = new MagicKey(this.c1);
        this.c1.put((Object)k1, (Object)"value");
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        this.assertIsNotInL1(this.c4, k1);
        assert (this.c4.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)k1, (Object)"new_val") == null);
        assert (((String)this.c3.get((Object)k1)).equals("new_val"));
        this.assertOnAllCachesAndOwnership(k1, "new_val");
    }

    @Test
    public void testSkipLookupOnRemove() {
        MagicKey k1 = new MagicKey(this.c1);
        String value = "SomethingToSayHere";
        assert (null == this.c1.put((Object)k1, (Object)"SomethingToSayHere"));
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        this.assertIsNotInL1(this.c4, k1);
        assert ("SomethingToSayHere".equals(this.c1.get((Object)k1)));
        assert ("SomethingToSayHere".equals(this.c1.remove((Object)k1)));
        assert (null == this.c1.put((Object)k1, (Object)"SomethingToSayHere"));
        this.assertIsNotInL1(this.c3, k1);
        assert ("SomethingToSayHere".equals(this.c3.remove((Object)k1)));
        assert (null == this.c1.put((Object)k1, (Object)"SomethingToSayHere"));
        assert (null == this.c4.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).remove((Object)k1));
    }

    @Test
    public void testSkipLookupOnAsyncRemove() throws InterruptedException, ExecutionException {
        MagicKey k1 = new MagicKey(this.c1);
        String value = "SomethingToSayHere-async";
        assert (null == this.c1.put((Object)k1, (Object)"SomethingToSayHere-async"));
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        this.assertIsNotInL1(this.c4, k1);
        assert ("SomethingToSayHere-async".equals(this.c1.get((Object)k1)));
        assert ("SomethingToSayHere-async".equals(this.c1.remove((Object)k1)));
        assert (null == this.c1.put((Object)k1, (Object)"SomethingToSayHere-async"));
        this.assertIsNotInL1(this.c3, k1);
        assert ("SomethingToSayHere-async".equals(this.c3.remove((Object)k1)));
        assert (null == this.c1.put((Object)k1, (Object)"SomethingToSayHere-async"));
        assert (null == this.c4.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)k1).get());
    }
}

