/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.L1OnRehashTest")
public class L1OnRehashTest
extends BaseDistFunctionalTest {
    EmbeddedCacheManager joinerManager;
    Cache<Object, String> joiner;

    public L1OnRehashTest() {
        this.tx = false;
        this.sync = true;
        this.l1CacheEnabled = true;
        this.performRehashing = true;
        this.l1OnRehash = true;
        this.INIT_CLUSTER_SIZE = 2;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    void performRehashEvent() {
        this.joinerManager = this.addClusterEnabledCacheManager();
        this.joinerManager.defineConfiguration(this.cacheName, this.configuration);
        this.joiner = this.joinerManager.getCache(this.cacheName);
    }

    int waitForJoinCompletion() {
        TestingUtil.blockUntilViewsReceived(TimeUnit.SECONDS.toMillis(10L), this.c1, this.c2, this.joiner);
        this.waitForClusterToForm(this.cacheName);
        int joinerPos = this.locateJoiner(this.joinerManager.getAddress());
        this.log.info((Object)("***>>> Joiner is in position " + joinerPos));
        this.caches.add(joinerPos, this.joiner);
        return joinerPos;
    }

    private List<MagicKey> init() {
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(Arrays.asList(new MagicKey(this.c1, "k1"), new MagicKey(this.c2, "k2")));
        int i = 0;
        for (Cache c : this.caches) {
            c.put(keys.get(i++), (Object)("v" + i));
        }
        i = 0;
        for (MagicKey key : keys) {
            this.assertOnAllCachesAndOwnership(key, "v" + ++i);
        }
        this.log.infof("Initialized with keys %s", keys);
        return keys;
    }

    public void testInvalidationBehaviorOnRehash() {
        List<MagicKey> keys = this.init();
        this.performRehashEvent();
        int joinerPos = this.waitForJoinCompletion();
        for (MagicKey key : keys) {
            this.assertOwnershipAndNonOwnership(key, this.l1OnRehash);
        }
    }
}

