/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheMBeanTest")
public class CacheMBeanTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(CacheMBeanTest.class);
    public static final String JMX_DOMAIN = CacheMBeanTest.class.getSimpleName();
    private MBeanServer server;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(JMX_DOMAIN);
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        return this.cacheManager;
    }

    public void testStartStopManagedOperations() throws Exception {
        ObjectName defaultOn = TestingUtil.getCacheObjectName(JMX_DOMAIN);
        ObjectName managerON = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        this.server.invoke(managerON, "startCache", new Object[0], new String[0]);
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("1"));
        this.server.invoke(defaultOn, "stop", new Object[0], new String[0]);
        assert (ComponentStatus.TERMINATED.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("0"));
        this.server.invoke(defaultOn, "start", new Object[0], new String[0]);
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("1"));
        this.server.invoke(defaultOn, "stop", new Object[0], new String[0]);
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("0"));
        assert (ComponentStatus.TERMINATED.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        this.server.invoke(defaultOn, "start", new Object[0], new String[0]);
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("1"));
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        this.server.invoke(defaultOn, "stop", new Object[0], new String[0]);
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("0"));
        assert (ComponentStatus.TERMINATED.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
    }

    public void testManagerStopRemovesCacheMBean(Method m) throws Exception {
        String otherJmxDomain = TestingUtil.getMethodSpecificJmxDomain(m, JMX_DOMAIN);
        ObjectName defaultOn = TestingUtil.getCacheObjectName(otherJmxDomain);
        ObjectName galderOn = TestingUtil.getCacheObjectName(otherJmxDomain, "galder(local)");
        ObjectName managerON = TestingUtil.getCacheManagerObjectName(otherJmxDomain);
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(otherJmxDomain);
        this.server.invoke(managerON, "startCache", new Object[0], new String[0]);
        this.server.invoke(managerON, "startCache", new Object[]{"galder"}, new String[]{String.class.getName()});
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(galderOn, "CacheStatus")));
        otherContainer.stop();
        try {
            log.info((Object)this.server.getMBeanInfo(managerON));
            assert (false) : "Failure expected, " + managerON + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
        try {
            log.info((Object)this.server.getMBeanInfo(defaultOn));
            assert (false) : "Failure expected, " + defaultOn + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
        try {
            log.info((Object)this.server.getMBeanInfo(galderOn));
            assert (false) : "Failure expected, " + galderOn + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicateJmxDomainOnlyCacheExposesJmxStatistics() throws Exception {
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(JMX_DOMAIN, false, true);
        try {
            otherContainer.getCache();
            assert (false) : "Failure expected, " + JMX_DOMAIN + " is a duplicate!";
        }
        catch (CacheException e) {
            assert (e.getCause() instanceof JmxDomainConflictException);
        }
        finally {
            otherContainer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMalformedCacheName(Method m) throws Exception {
        String otherJmxDomain = JMX_DOMAIN + '.' + m.getName();
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(otherJmxDomain);
        try {
            otherContainer.getCache("persistence.unit:unitName=#helloworld.MyRegion");
        }
        finally {
            otherContainer.stop();
        }
    }
}

