/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="remoting.MessageSentToLeaverTest", groups={"functional"})
public class MessageSentToLeaverTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupRequestSentToMemberAfterLeaving() {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        EmbeddedCacheManager cm3 = null;
        try {
            Configuration c = new Configuration().fluent().mode(Configuration.CacheMode.DIST_SYNC).hash().numOwners(Integer.valueOf(3)).build();
            GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
            cm1 = TestCacheManagerFactory.createCacheManager(gc, c);
            cm2 = TestCacheManagerFactory.createCacheManager(gc, c);
            cm3 = TestCacheManagerFactory.createCacheManager(gc, c);
            Cache c1 = cm1.getCache();
            Cache c2 = cm2.getCache();
            Cache c3 = cm3.getCache();
            TestingUtil.blockUntilViewsReceived(30000L, c1, c2, c3);
            c2.put((Object)"k", (Object)"v1");
            RpcManager rpcManager = TestingUtil.extractComponent(c1, RpcManager.class);
            List addresses = cm1.getMembers();
            CommandsFactory cf = TestingUtil.extractCommandsFactory((Cache<Object, Object>)c1);
            PutKeyValueCommand cmd = cf.buildPutKeyValueCommand((Object)"k", (Object)"v2", -1L, -1L, null);
            Map responseMap = rpcManager.invokeRemotely((Collection)addresses, (ReplicableCommand)cmd, true, true);
            assert (responseMap.size() == 2);
            TestingUtil.killCacheManagers(cm2);
            TestingUtil.blockUntilViewsReceived(30000L, false, c1, c3);
            try {
                responseMap = rpcManager.invokeRemotely((Collection)addresses, (ReplicableCommand)cmd, true, true);
                assert (false) : "invokeRemotely should have thrown an exception";
            }
            catch (SuspectException e) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2, cm3);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2, cm3);
    }
}

