/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.LocalModeTxTest")
public class LocalModeTxTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(true);
        this.cache = cm.getCache();
        return cm;
    }

    public void testTxCommit1() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        Transaction t = tm.suspend();
        assert (this.cache.isEmpty());
        tm.resume(t);
        tm.commit();
        assert (!this.cache.isEmpty());
    }

    public void testTxCommit3() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        tm.commit();
        assert (!this.cache.isEmpty());
    }

    public void testNonTx() throws Exception {
        this.cache.put((Object)"key", (Object)"value");
        assert (!this.cache.isEmpty());
    }

    public void testTxCommit2() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        this.cache.put((Object)"key", (Object)"old");
        tm.begin();
        assert (this.cache.get((Object)"key").equals("old"));
        this.cache.put((Object)"key", (Object)"value");
        assert (this.cache.get((Object)"key").equals("value"));
        Transaction t = tm.suspend();
        assert (this.cache.get((Object)"key").equals("old"));
        tm.resume(t);
        tm.commit();
        assert (this.cache.get((Object)"key").equals("value"));
        assert (!this.cache.isEmpty());
    }

    public void testKeySet() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
        this.tm().commit();
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
    }

    public void testKeySet2() throws Exception {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
        this.tm().begin();
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
        this.cache.remove((Object)"k1");
        assert (this.cache.keySet().size() == 1);
        assert (this.cache.values().size() == 1);
        this.tm().rollback();
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
    }

    public void testKeySetAlterValue() throws Exception {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
        this.tm().begin();
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
        this.cache.put((Object)"k1", (Object)"v3");
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
        assert (this.cache.values().contains("v3"));
        this.tm().rollback();
        assert (this.cache.keySet().size() == 2);
        assert (this.cache.values().size() == 2);
    }
}

