/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ControlledRpcManager
implements RpcManager {
    private static final Log log = LogFactory.getLog(ControlledRpcManager.class);
    private volatile CountDownLatch replicationLatch;
    private boolean fail;
    protected RpcManager realOne;

    public ControlledRpcManager(RpcManager realOne) {
        this(realOne, new CountDownLatch(1));
        this.replicationLatch.countDown();
    }

    public ControlledRpcManager(RpcManager realOne, CountDownLatch latch) {
        this.realOne = realOne;
        this.replicationLatch = latch;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean fail) {
        this.fail = fail;
    }

    public void setReplicationLatch(CountDownLatch replicationLatch) {
        this.replicationLatch = replicationLatch;
    }

    protected void waitFirst(ReplicableCommand rpcCommand) {
        this.failIfNeeded();
        boolean isLockControlCommand = rpcCommand instanceof LockControlCommand;
        boolean isClusterGet = rpcCommand instanceof ClusteredGetCommand;
        if (!isClusterGet && !isLockControlCommand) {
            log.debugf("%s -- replication trigger called!", (Object)Thread.currentThread().getName());
            this.waitForLatchToOpen();
        }
    }

    protected void waitForLatchToOpen() {
        try {
            this.replicationLatch.await();
            log.trace((Object)"Replication latch opened, continuing...");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception!", e);
        }
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
        log.trace((Object)"invokeRemotely1");
        this.waitFirst(rpcCommand);
        return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
        log.trace((Object)"invokeRemotely2");
        this.waitFirst(rpcCommand);
        return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
        log.trace((Object)"invokeRemotely3");
        this.waitFirst(rpcCommand);
        return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout);
    }

    public void invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync) throws RpcException {
        log.trace((Object)"invokeRemotely4");
        this.waitFirst(rpc);
        this.realOne.invokeRemotely(recipients, rpc, sync);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        log.trace((Object)"invokeRemotely5");
        Map responses = this.realOne.invokeRemotely(recipients, rpc, sync, usePriorityQueue);
        this.waitForLatchToOpen();
        return responses;
    }

    public void broadcastRpcCommand(ReplicableCommand rpc, boolean sync) throws RpcException {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommand1");
        this.waitFirst(rpc);
        this.realOne.broadcastRpcCommand(rpc, sync);
    }

    public void broadcastRpcCommand(ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommand2");
        this.failIfNeeded();
        this.realOne.broadcastRpcCommand(rpc, sync, usePriorityQueue);
        this.waitForLatchToOpen();
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpc, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture1");
        this.waitFirst(rpc);
        this.realOne.broadcastRpcCommandInFuture(rpc, future);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture2");
        this.waitFirst(rpc);
        this.realOne.broadcastRpcCommandInFuture(rpc, usePriorityQueue, future);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture1");
        this.waitFirst(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, future);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture2");
        this.waitFirst(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture3");
        this.waitFirst(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future, timeout);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout, boolean ignoreLeavers) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture4");
        this.waitFirst(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future, timeout, ignoreLeavers);
    }

    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    public Address getAddress() {
        return this.realOne.getAddress();
    }

    public void failIfNeeded() {
        if (this.fail) {
            throw new IllegalStateException("Induced failure!");
        }
    }
}

