/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.IMethodExecutor;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.exceptions.UnauthenticatedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoCopy;
import org.modeshape.webdav.methods.DoDelete;
import org.modeshape.webdav.methods.DoGet;
import org.modeshape.webdav.methods.DoHead;
import org.modeshape.webdav.methods.DoLock;
import org.modeshape.webdav.methods.DoMkcol;
import org.modeshape.webdav.methods.DoMove;
import org.modeshape.webdav.methods.DoNotImplemented;
import org.modeshape.webdav.methods.DoOptions;
import org.modeshape.webdav.methods.DoPropfind;
import org.modeshape.webdav.methods.DoProppatch;
import org.modeshape.webdav.methods.DoPut;
import org.modeshape.webdav.methods.DoUnlock;

public class WebDavServletBean
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(WebDavServletBean.class);
    protected static MessageDigest MD5_HELPER;
    private static final boolean READ_ONLY = false;
    protected final ResourceLocks resLocks;
    protected IWebdavStore store;
    private Map<String, IMethodExecutor> methodMap = new HashMap<String, IMethodExecutor>();

    public WebDavServletBean() {
        this.resLocks = new ResourceLocks();
        try {
            MD5_HELPER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public void init(IWebdavStore store, String dftIndexFile, String insteadOf404, int nocontentLenghHeaders, boolean lazyFolderCreationOnPut) throws ServletException {
        this.store = store;
        IMimeTyper mimeTyper = new IMimeTyper(){

            @Override
            public String getMimeType(ITransaction transaction, String path) {
                String retVal = WebDavServletBean.this.store.getStoredObject(transaction, path).getMimeType();
                if (retVal == null) {
                    retVal = WebDavServletBean.this.getServletContext().getMimeType(path);
                }
                return retVal;
            }
        };
        this.register("GET", new DoGet(store, dftIndexFile, insteadOf404, this.resLocks, mimeTyper, nocontentLenghHeaders));
        this.register("HEAD", new DoHead(store, dftIndexFile, insteadOf404, this.resLocks, mimeTyper, nocontentLenghHeaders));
        DoDelete doDelete = (DoDelete)this.register("DELETE", new DoDelete(store, this.resLocks, false));
        DoCopy doCopy = (DoCopy)this.register("COPY", new DoCopy(store, this.resLocks, doDelete, false));
        this.register("LOCK", new DoLock(store, this.resLocks, false));
        this.register("UNLOCK", new DoUnlock(store, this.resLocks, false));
        this.register("MOVE", new DoMove(this.resLocks, doDelete, doCopy, false));
        this.register("MKCOL", new DoMkcol(store, this.resLocks, false));
        this.register("OPTIONS", new DoOptions(store, this.resLocks));
        this.register("PUT", new DoPut(store, this.resLocks, false, lazyFolderCreationOnPut));
        this.register("PROPFIND", new DoPropfind(store, this.resLocks, mimeTyper));
        this.register("PROPPATCH", new DoProppatch(store, this.resLocks, false));
        this.register("*NO*IMPL*", new DoNotImplemented(false));
    }

    public void destroy() {
        if (this.store != null) {
            this.store.destroy();
        }
        super.destroy();
    }

    protected IMethodExecutor register(String methodName, IMethodExecutor method) {
        this.methodMap.put(methodName, method);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String methodName = req.getMethod();
        ITransaction transaction = null;
        boolean needRollback = false;
        if (LOG.isTraceEnabled()) {
            this.debugRequest(methodName, req);
        }
        try {
            Principal userPrincipal = req.getUserPrincipal();
            transaction = this.store.begin(userPrincipal);
            needRollback = true;
            this.store.checkAuthentication(transaction);
            resp.setStatus(200);
            try {
                IMethodExecutor methodExecutor = this.methodMap.get(methodName);
                if (methodExecutor == null) {
                    methodExecutor = this.methodMap.get("*NO*IMPL*");
                }
                methodExecutor.execute(transaction, req, resp);
                this.store.commit(transaction);
                if (req.getContentLength() != 0 && req.getInputStream().available() > 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Clear not consumed data!", new Object[0]);
                    }
                    while (req.getInputStream().available() > 0) {
                        req.getInputStream().read();
                    }
                }
                needRollback = false;
            }
            catch (IOException e) {
                LOG.error((Throwable)e, (I18nResource)new TextI18n("IOException"), new Object[0]);
                resp.sendError(500);
                this.store.rollback(transaction);
                throw new ServletException((Throwable)e);
            }
        }
        catch (UnauthenticatedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            LOG.error((Throwable)e, (I18nResource)new TextI18n("WebdavException"), new Object[0]);
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, (I18nResource)new TextI18n("Exception"), new Object[0]);
        }
        finally {
            if (needRollback) {
                this.store.rollback(transaction);
            }
        }
    }

    private void debugRequest(String methodName, HttpServletRequest req) {
        String s;
        LOG.trace("-----------", new Object[0]);
        LOG.trace("WebdavServlet\n request: methodName = " + methodName, new Object[0]);
        LOG.trace("time: " + System.currentTimeMillis(), new Object[0]);
        LOG.trace("path: " + req.getRequestURI(), new Object[0]);
        LOG.trace("-----------", new Object[0]);
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.trace("header: " + s + " " + req.getHeader(s), new Object[0]);
        }
        e = req.getAttributeNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.trace("attribute: " + s + " " + req.getAttribute(s), new Object[0]);
        }
        e = req.getParameterNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.trace("parameter: " + s + " " + req.getParameter(s), new Object[0]);
        }
    }
}

