/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoLock;
import org.modeshape.webdav.methods.DoPut;
import org.springframework.mock.web.DelegatingServletInputStream;

public class DoPutTest
extends AbstractWebDAVTest {
    private static final String PARENT_PATH = "/parentCollection";
    private static final String PATH = "/parentCollection/fileToPut";
    private static final boolean LAZY_FOLDER_CREATION_ON_PUT = true;

    @Test
    public void testDoPutIfReadOnlyTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).sendError(403);
            }
        });
        DoPut doPut = new DoPut(this.mockStore, (IResourceLocks)new ResourceLocks(), true, true);
        doPut.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoPutIfReadOnlyFalse() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)DoPutTest.PATH));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("User-Agent");
                this.will(2.returnValue((Object)"Goliath agent"));
                StoredObject parentSo = DoPutTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(2.returnValue((Object)parentSo));
                StoredObject fileSo = null;
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(2.returnValue(fileSo));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).createResource(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).setStatus(201);
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getInputStream();
                DelegatingServletInputStream resourceStream = DoPutTest.this.resourceRequestStream();
                this.will(2.returnValue((Object)resourceStream));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).setResourceContent(DoPutTest.this.mockTransaction, DoPutTest.PATH, (InputStream)resourceStream, null, null);
                this.will(2.returnValue((Object)RESOURCE_LENGTH));
                fileSo = DoPutTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(2.returnValue((Object)fileSo));
            }
        });
        DoPut doPut = new DoPut(this.mockStore, (IResourceLocks)new ResourceLocks(), false, true);
        doPut.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoPutIfLazyFolderCreationOnPutIsFalse() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)DoPutTest.PATH));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("User-Agent");
                this.will(3.returnValue((Object)"Transmit agent"));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(3.returnValue(null));
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).sendError(this.with(3.equal((Object)404)), (String)this.with(3.any(String.class)));
            }
        });
        DoPut doPut = new DoPut(this.mockStore, (IResourceLocks)new ResourceLocks(), false, false);
        doPut.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoPutIfLazyFolderCreationOnPutIsTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)DoPutTest.PATH));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("User-Agent");
                this.will(4.returnValue((Object)"WebDAVFS/1.5.0 (01500000) ....."));
                Object parentSo = null;
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(4.returnValue(parentSo));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).createFolder(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                StoredObject fileSo = null;
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(4.returnValue(fileSo));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).createResource(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).setStatus(201);
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getInputStream();
                DelegatingServletInputStream resourceStream = DoPutTest.this.resourceRequestStream();
                this.will(4.returnValue((Object)resourceStream));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).setResourceContent(DoPutTest.this.mockTransaction, DoPutTest.PATH, (InputStream)resourceStream, null, null);
                this.will(4.returnValue((Object)RESOURCE_LENGTH));
                fileSo = DoPutTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(4.returnValue((Object)fileSo));
            }
        });
        DoPut doPut = new DoPut(this.mockStore, (IResourceLocks)new ResourceLocks(), false, true);
        doPut.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoPutIfParentPathIsResource() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)DoPutTest.PATH));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("User-Agent");
                this.will(5.returnValue((Object)"WebDAVFS/1.5.0 (01500000) ....."));
                StoredObject parentSo = DoPutTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(5.returnValue((Object)parentSo));
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).sendError(403);
            }
        });
        DoPut doPut = new DoPut(this.mockStore, (IResourceLocks)new ResourceLocks(), false, true);
        doPut.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoPutOnALockNullResource() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)DoPutTest.PATH));
                LockedObject lockNullResourceLo = null;
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByPath(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue(lockNullResourceLo));
                Object parentLo = null;
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByPath(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(6.returnValue(parentLo));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("User-Agent");
                this.will(6.returnValue((Object)"Transmit agent"));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).lock((ITransaction)this.with(6.any(ITransaction.class)), (String)this.with(6.any(String.class)), (String)this.with(6.any(String.class)), this.with(6.any(Boolean.TYPE)), this.with(6.any(Integer.TYPE)), this.with(6.any(Integer.TYPE)), this.with(6.any(Boolean.TYPE)));
                this.will(6.returnValue((Object)true));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("If");
                this.will(6.returnValue(null));
                StoredObject lockNullResourceSo = null;
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue(lockNullResourceSo));
                StoredObject parentSo = null;
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(6.returnValue(parentSo));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).createFolder(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                parentSo = DoPutTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue(lockNullResourceSo));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).createResource(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                lockNullResourceSo = DoPutTest.this.initLockNullStoredObject();
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue((Object)lockNullResourceSo));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getInputStream();
                this.will(6.returnValue((Object)DoPutTest.this.exclusiveLockRequestStream()));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("Depth");
                this.will(6.returnValue((Object)"0"));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("Timeout");
                this.will(6.returnValue((Object)"Infinite"));
                ResourceLocks resLocks = (ResourceLocks)ResourceLocks.class.newInstance();
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).exclusiveLock(DoPutTest.this.mockTransaction, DoPutTest.PATH, "I'am the Lock Owner", 0, 604800);
                this.will(6.returnValue((Object)true));
                lockNullResourceLo = DoPutTest.this.initLockNullLockedObject(resLocks, DoPutTest.PATH);
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByPath(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue((Object)lockNullResourceLo));
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).getWriter();
                this.will(6.returnValue((Object)DoPutTest.this.getPrintWriter()));
                String loId = null;
                if (lockNullResourceLo != null) {
                    loId = lockNullResourceLo.getID();
                }
                String lockToken = "<opaquelocktoken:" + loId + ">";
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).addHeader("Lock-Token", lockToken);
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(6.any(ITransaction.class)), (String)this.with(6.any(String.class)), (String)this.with(6.any(String.class)));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)DoPutTest.PATH));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("User-Agent");
                this.will(6.returnValue((Object)"Transmit agent"));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByPath(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(6.returnValue(parentLo));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByPath(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue((Object)lockNullResourceLo));
                String ifHeaderLockToken = "(<locktoken:" + loId + ">)";
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("If");
                this.will(6.returnValue((Object)ifHeaderLockToken));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByID(DoPutTest.this.mockTransaction, loId);
                this.will(6.returnValue((Object)lockNullResourceLo));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).lock((ITransaction)this.with(6.any(ITransaction.class)), (String)this.with(6.any(String.class)), (String)this.with(6.any(String.class)), this.with(6.any(Boolean.TYPE)), this.with(6.any(Integer.TYPE)), this.with(6.any(Integer.TYPE)), this.with(6.any(Boolean.TYPE)));
                this.will(6.returnValue((Object)true));
                parentSo = DoPutTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PARENT_PATH);
                this.will(6.returnValue((Object)parentSo));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue((Object)lockNullResourceSo));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).getLockedObjectByPath(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue((Object)lockNullResourceLo));
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getHeader("If");
                this.will(6.returnValue((Object)ifHeaderLockToken));
                String[] owners = lockNullResourceLo.getOwner();
                String owner = null;
                if (owners != null) {
                    owner = owners[0];
                }
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).unlock(DoPutTest.this.mockTransaction, loId, owner);
                this.will(6.returnValue((Object)true));
                ((HttpServletResponse)this.one(DoPutTest.this.mockRes)).setStatus(204);
                ((HttpServletRequest)this.one(DoPutTest.this.mockReq)).getInputStream();
                DelegatingServletInputStream resourceStream = DoPutTest.this.resourceRequestStream();
                this.will(6.returnValue((Object)resourceStream));
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).setResourceContent(DoPutTest.this.mockTransaction, DoPutTest.PATH, (InputStream)resourceStream, null, null);
                this.will(6.returnValue((Object)RESOURCE_LENGTH));
                StoredObject newResourceSo = DoPutTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoPutTest.this.mockStore)).getStoredObject(DoPutTest.this.mockTransaction, DoPutTest.PATH);
                this.will(6.returnValue((Object)newResourceSo));
                ((IResourceLocks)this.one(DoPutTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(6.any(ITransaction.class)), (String)this.with(6.any(String.class)), (String)this.with(6.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, this.mockResourceLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        DoPut doPut = new DoPut(this.mockStore, this.mockResourceLocks, false, true);
        doPut.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

