/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddLocalFileSystemIndexStorage
extends AbstractAddFileSystemIndexStorage {
    public static final AddLocalFileSystemIndexStorage INSTANCE = new AddLocalFileSystemIndexStorage();

    private AddLocalFileSystemIndexStorage() {
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage) throws OperationFailedException {
        indexStorage.set("type", (Object)"filesystem");
        String accessType = ModelAttributes.ACCESS_TYPE.resolveModelAttribute(context, storage).asString();
        String locking = ModelAttributes.LOCKING_STRATEGY.resolveModelAttribute(context, storage).asString();
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, storage).asString();
        String path = ModelAttributes.PATH.resolveModelAttribute(context, storage).asString();
        if (storage.has("relative-to") && storage.get("relative-to").asString().contains("jboss.server.data.dir")) {
            this.setIndexStoragePathInDataDirectory(path);
        }
        path = relativeTo + path;
        indexStorage.set("type", (Object)"filesystem");
        indexStorage.set("location", (Object)path);
        indexStorage.set("lockingStrategy", (Object)locking.toLowerCase());
        indexStorage.set("fileSystemAccessType", (Object)accessType.toLowerCase());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddLocalFileSystemIndexStorage.populate(operation, model, "local-file-index-storage", ModelAttributes.LOCAL_FILE_INDEX_STORAGE_ATTRIBUTES);
    }
}

