/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.nio.ByteBuffer;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyException;
import org.xerial.snappy.SnappyNative;

public class Snappy {
    public static String getNativeLibraryVersion() {
        return SnappyNative.nativeLibraryVersion();
    }

    public static byte[] compress(byte[] input) throws SnappyException {
        byte[] buf = new byte[Snappy.maxCompressedLength(input.length)];
        int compressedByteSize = Snappy.compress(input, 0, input.length, buf, 0);
        byte[] result = new byte[compressedByteSize];
        System.arraycopy(buf, 0, result, 0, compressedByteSize);
        return result;
    }

    public static byte[] uncompress(byte[] input) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, 0, input.length);
        byte[] result = new byte[uncompressedLength];
        int byteSize = Snappy.uncompress(input, 0, input.length, result, 0);
        if (byteSize != uncompressedLength) {
            throw new SnappyException(SnappyErrorCode.INVALID_DECOMPRESSION);
        }
        return result;
    }

    public static int compress(ByteBuffer uncompressed, ByteBuffer compressed) throws SnappyException {
        if (!uncompressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int uPos = uncompressed.position();
        int uLen = uncompressed.remaining();
        int compressedSize = SnappyNative.rawCompress(uncompressed, uPos, uLen, compressed, compressed.position());
        compressed.limit(compressed.position() + compressedSize);
        return compressedSize;
    }

    public static int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws SnappyException {
        if (input == null || output == null) {
            throw new NullPointerException("input or output is null");
        }
        int compressedSize = SnappyNative.rawCompress(input, inputOffset, inputLength, output, outputOffset);
        return compressedSize;
    }

    public static int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws SnappyException {
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!uncompressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int cPos = compressed.position();
        int cLen = compressed.remaining();
        int decompressedSize = SnappyNative.rawUncompress(compressed, cPos, cLen, uncompressed, uncompressed.position());
        uncompressed.limit(uncompressed.position() + decompressedSize);
        return decompressedSize;
    }

    public static int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws SnappyException {
        if (input == null || output == null) {
            throw new NullPointerException("input or output is null");
        }
        return SnappyNative.rawUncompress(input, inputOffset, inputLength, output, outputOffset);
    }

    public static int uncompressedLength(ByteBuffer compressed) throws SnappyException {
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        return SnappyNative.uncompressedLength(compressed, compressed.position(), compressed.remaining());
    }

    public static int uncompressedLength(byte[] input, int offset, int length) throws SnappyException {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        return SnappyNative.uncompressedLength(input, offset, length);
    }

    public static int maxCompressedLength(int byteSize) {
        return SnappyNative.maxCompressedLength(byteSize);
    }

    public static boolean isValidCompressedBuffer(ByteBuffer compressed) throws SnappyException {
        return SnappyNative.isValidCompressedBuffer(compressed, compressed.position(), compressed.remaining());
    }

    public static boolean isValidCompressedBuffer(byte[] input, int offset, int length) throws SnappyException {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        return SnappyNative.isValidCompressedBuffer(input, offset, length);
    }
}

