/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.MappedAttributeDefinitionBuilder;
import org.modeshape.jboss.subsystem.MappedListAttributeDefinition;
import org.modeshape.jboss.subsystem.PathExpressionValidator;
import org.modeshape.jboss.subsystem.RegexValidator;
import org.modeshape.jcr.RepositoryConfiguration;

public class ModelAttributes {
    private static final ParameterValidator ROLE_NAME_VALIDATOR = new ModelTypeValidator(ModelType.STRING, false, false, true){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String str = value.asString();
            if (!("admin".equals(str) || "readonly".equals(str) || "readwrite".equals(str))) {
                throw new OperationFailedException("Invalid anonymous role name: '" + str + "'");
            }
        }
    };
    private static final ParameterValidator BINARY_STORAGE_TYPE_VALIDATOR = new ModelTypeValidator(ModelType.STRING, false, false, true){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String str = value.asString();
            if (!("file-binary-storage".equals(str) || "db-binary-storage".equals(str) || "cache-binary-storage".equals(str) || "custom-binary-storage".equals(str))) {
                throw new OperationFailedException("Invalid binary storage type: '" + str + "'");
            }
        }
    };
    private static final ParameterValidator INDEX_STORAGE_TYPE_VALIDATOR = new ModelTypeValidator(ModelType.STRING, false, false, true){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String str = value.asString();
            if (!("ram-index-storage".equals(str) || "local-file-index-storage".equals(str) || "master-file-index-storage".equals(str) || "slave-file-index-storage".equals(str) || "cache-index-storage".equals(str) || "custom-index-storage".equals(str))) {
                throw new OperationFailedException("Invalid index storage type: '" + str + "'");
            }
        }
    };
    private static final ParameterValidator WORKSPACE_NAME_VALIDATOR = new ModelTypeValidator(ModelType.STRING, false, false, true);
    private static final ParameterValidator NODE_TYPE_VALIDATOR = new ModelTypeValidator(ModelType.STRING, false, false, true);
    private static final ParameterValidator INITIAL_CONTENT_VALIDATOR = new ModelTypeValidator(ModelType.PROPERTY, false, false, true);
    private static final ParameterValidator DEFAULT_INITIAL_CONTENT_VALIDATOR = new ModelTypeValidator(ModelType.STRING, true, false, true);
    private static final ParameterValidator INDEX_FORMAT_VALIDATOR = new RegexValidator("LUCENE_(3[0-9]{1,2}|CURRENT)", true);
    private static final ParameterValidator REBUILD_INDEXES_VALIDATOR = new EnumValidator(RepositoryConfiguration.QueryRebuild.class, false, true);
    private static final ParameterValidator ACCESS_TYPE_VALIDATOR = new EnumValidator(RepositoryConfiguration.FileSystemAccessType.class, false, true);
    private static final ParameterValidator LOCKING_STRATEGY_VALIDATOR = new EnumValidator(RepositoryConfiguration.FileSystemLockingStrategy.class, false, true);
    private static final ParameterValidator READER_STRATEGY_VALIDATOR = new EnumValidator(RepositoryConfiguration.IndexReaderStrategy.class, false, true);
    private static final ParameterValidator INDEXING_MODE_VALIDATOR = new EnumValidator(RepositoryConfiguration.IndexingMode.class, false, true);
    private static final ParameterValidator PATH_EXPRESSION_VALIDATOR = new PathExpressionValidator(false);
    public static final SimpleAttributeDefinition ACCESS_TYPE = new MappedAttributeDefinitionBuilder("access-type", ModelType.STRING).setXmlName(Attribute.ACCESS_TYPE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(RepositoryConfiguration.FileSystemAccessType.AUTO.toString())).setValidator(ACCESS_TYPE_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition ALLOW_WORKSPACE_CREATION = new MappedAttributeDefinitionBuilder("allow-workspace-creation", ModelType.BOOLEAN).setXmlName(Attribute.ALLOW_WORKSPACE_CREATION.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(true)).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("workspaces", "allowCreation").build();
    public static final SimpleAttributeDefinition WORKSPACES_CACHE_CONTAINER = new MappedAttributeDefinitionBuilder("workspaces-cache-container", ModelType.STRING).setXmlName(Attribute.CACHE_CONTAINER.getLocalName()).setAllowExpression(true).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_NONE).build();
    public static final SimpleAttributeDefinition ANALYZER_CLASSNAME = new MappedAttributeDefinitionBuilder("indexing-analyzer-classname", ModelType.STRING).setXmlName(Attribute.ANALYZER_CLASSNAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setDefaultValue(new ModelNode().set(StandardAnalyzer.class.getName())).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition ANALYZER_MODULE = new MappedAttributeDefinitionBuilder("indexing-analyzer-module", ModelType.STRING).setXmlName(Attribute.ANALYZER_MODULE.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final ListAttributeDefinition ANONYMOUS_ROLES = MappedListAttributeDefinition.Builder.of("anonymous-roles", new MappedAttributeDefinitionBuilder("anonymous-role", ModelType.STRING).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().add(new ModelNode().set("admin")).add(new ModelNode().set("readonly")).add(new ModelNode().set("readwrite"))).setValidator(ROLE_NAME_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_NONE).build()).setAllowNull(true).setMinSize(0).setMaxSize(100).setFieldPathInRepositoryConfiguration("security", "anonymous", "roles").build();
    public static final SimpleAttributeDefinition ANONYMOUS_USERNAME = new MappedAttributeDefinitionBuilder("anonymous-username", ModelType.STRING).setXmlName(Attribute.ANONYMOUS_USERNAME.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("<anonymous>")).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("security", "anonymous", "username").build();
    public static final SimpleAttributeDefinition ASYNC_MAX_QUEUE_SIZE = new MappedAttributeDefinitionBuilder("indexing-async-max-queue-size", ModelType.INT).setXmlName(Attribute.ASYNC_MAX_QUEUE_SIZE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(0)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition ASYNC_THREAD_POOL_SIZE = new MappedAttributeDefinitionBuilder("indexing-async-thread-pool-size", ModelType.INT).setXmlName(Attribute.ASYNC_THREAD_POOL_SIZE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(1)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition BATCH_SIZE = new MappedAttributeDefinitionBuilder("indexing-batch-size", ModelType.INT).setXmlName(Attribute.BATCH_SIZE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(-1)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition BINARY_STORAGE_TYPE = new MappedAttributeDefinitionBuilder("binary-storage-type", ModelType.STRING).setAllowExpression(false).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).setDefaultValue(new ModelNode().set("file-binary-storage")).setValidator(BINARY_STORAGE_TYPE_VALIDATOR).build();
    public static final SimpleAttributeDefinition CACHE_NAME = new MappedAttributeDefinitionBuilder("cache-name", ModelType.STRING).setXmlName(Attribute.CACHE_NAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition CACHE_CONTAINER = new MappedAttributeDefinitionBuilder("cache-container", ModelType.STRING).setXmlName(Attribute.CACHE_CONTAINER.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition INDEX_STORAGE_CACHE_CONTAINER = new MappedAttributeDefinitionBuilder("cache-container", ModelType.STRING).setXmlName(Attribute.CACHE_CONTAINER.getLocalName()).setAllowExpression(false).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition CLUSTER_NAME = new MappedAttributeDefinitionBuilder("cluster-name", ModelType.STRING).setXmlName(Attribute.CLUSTER_NAME.getLocalName()).setAllowExpression(true).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition CLUSTER_STACK = new MappedAttributeDefinitionBuilder("cluster-stack", ModelType.STRING).setXmlName(Attribute.CLUSTER_STACK.getLocalName()).setAllowExpression(true).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition CHUNK_SIZE = new MappedAttributeDefinitionBuilder("chunk-size", ModelType.INT).setXmlName(Attribute.CHUNK_SIZE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(16834)).setMeasurementUnit(MeasurementUnit.BYTES).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("query", "indexStorage", "chunkSizeInBytes").build();
    public static final SimpleAttributeDefinition CLASSNAME = new MappedAttributeDefinitionBuilder("classname", ModelType.STRING).setXmlName(Attribute.CLASSNAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition CONNECTION_FACTORY_JNDI_NAME = new MappedAttributeDefinitionBuilder("connection-factory-jndi-name", ModelType.STRING).setXmlName(Attribute.CONNECTION_FACTORY_JNDI_NAME.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("/ConnectionFactory")).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition COPY_BUFFER_SIZE = new MappedAttributeDefinitionBuilder("copy-buffer-size", ModelType.INT).setXmlName(Attribute.COPY_BUFFER_SIZE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(16)).setMeasurementUnit(MeasurementUnit.MEGABYTES).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("query", "indexStorage", "copyBufferSizeInMegabytes").build();
    public static final SimpleAttributeDefinition DATA_CACHE_NAME = new MappedAttributeDefinitionBuilder("data-cache-name", ModelType.STRING).setXmlName(Attribute.DATA_CACHE_NAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition DATA_SOURCE_JNDI_NAME = new MappedAttributeDefinitionBuilder("data-source-jndi-name", ModelType.STRING).setXmlName(Attribute.DATA_SOURCE_JNDI_NAME.getLocalName()).setAllowExpression(true).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition DEFAULT_WORKSPACE = new MappedAttributeDefinitionBuilder("default-workspace", ModelType.STRING).setXmlName(Attribute.DEFAULT_WORKSPACE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("default")).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("workspaces", "default").build();
    public static final SimpleAttributeDefinition ENABLE_MONITORING = new MappedAttributeDefinitionBuilder("enable-monitoring", ModelType.BOOLEAN).setXmlName(Attribute.ENABLE_MONITORING.getLocalName()).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode().set(true)).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("monitoring", "enabled").build();
    public static final SimpleAttributeDefinition INDEX_FORMAT = new MappedAttributeDefinitionBuilder("index-format", ModelType.STRING).setXmlName(Attribute.FORMAT.getLocalName()).setAllowExpression(true).setAllowNull(true).setValidator(INDEX_FORMAT_VALIDATOR).setDefaultValue(new ModelNode().set("LUCENE_CURRENT")).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition INDEX_STORAGE_TYPE = new MappedAttributeDefinitionBuilder("index-storage-type", ModelType.STRING).setAllowExpression(false).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).setDefaultValue(new ModelNode().set("local-file-index-storage")).setValidator(INDEX_STORAGE_TYPE_VALIDATOR).build();
    public static final SimpleAttributeDefinition JNDI_NAME = new MappedAttributeDefinitionBuilder("jndi-name", ModelType.STRING).setXmlName(Attribute.JNDI_NAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition LOCK_CACHE_NAME = new MappedAttributeDefinitionBuilder("lock-cache-name", ModelType.STRING).setXmlName(Attribute.LOCK_CACHE_NAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition LOCKING_STRATEGY = new MappedAttributeDefinitionBuilder("locking-strategy", ModelType.STRING).setXmlName(Attribute.LOCKING_STRATEGY.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(RepositoryConfiguration.FileSystemLockingStrategy.NATIVE.toString())).setValidator(LOCKING_STRATEGY_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition METADATA_CACHE_NAME = new MappedAttributeDefinitionBuilder("metadata-cache-name", ModelType.STRING).setXmlName(Attribute.META_CACHE_NAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition MINIMUM_BINARY_SIZE = new MappedAttributeDefinitionBuilder("minimum-binary-size", ModelType.INT).setXmlName(Attribute.MIN_VALUE_SIZE.getLocalName()).setAllowExpression(false).setAllowNull(true).setDefaultValue(new ModelNode().set(4096)).setMeasurementUnit(MeasurementUnit.BYTES).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("storage", "binaryStorage", "minimumBinarySizeInBytes").build();
    public static final SimpleAttributeDefinition MODE = new MappedAttributeDefinitionBuilder("indexing-mode", ModelType.STRING).setXmlName(Attribute.MODE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(RepositoryConfiguration.IndexingMode.SYNC.toString())).setValidator(INDEXING_MODE_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition SYSTEM_CONTENT_MODE = new MappedAttributeDefinitionBuilder("system-content-indexing-mode", ModelType.STRING).setXmlName(Attribute.SYSTEM_CONTENT_MODE.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(RepositoryConfiguration.IndexingMode.DISABLED.toString())).setValidator(INDEXING_MODE_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition MODULE = new MappedAttributeDefinitionBuilder("module", ModelType.STRING).setXmlName(Attribute.MODULE.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition NAME = new MappedAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName(Attribute.NAME.getLocalName()).setAllowExpression(false).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition PATH = new MappedAttributeDefinitionBuilder("path", ModelType.STRING).setXmlName(Attribute.PATH.getLocalName()).setAllowExpression(true).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final ListAttributeDefinition PATH_EXPRESSIONS = MappedListAttributeDefinition.Builder.of("path-expressions", new MappedAttributeDefinitionBuilder("path-expression", ModelType.STRING).setAllowExpression(true).setAllowNull(false).setValidator(PATH_EXPRESSION_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_NONE).build()).setAllowNull(false).setMinSize(1).setFieldPathInRepositoryConfiguration("sequencing", "sequencers", "pathExpressions").build();
    public static final ListAttributeDefinition PREDEFINED_WORKSPACE_NAMES = MappedListAttributeDefinition.Builder.of("predefined-workspace-names", new MappedAttributeDefinitionBuilder("predefined-workspace-name", ModelType.STRING).setAllowExpression(true).setAllowNull(false).setValidator(WORKSPACE_NAME_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_NONE).build()).setAllowNull(true).setMinSize(0).setFieldPathInRepositoryConfiguration("workspaces", "predefined").build();
    public static final SimpleAttributeDefinition DEFAULT_INITIAL_CONTENT = new MappedAttributeDefinitionBuilder("default-initial-content", ModelType.STRING).setAllowExpression(false).setAllowNull(true).setValidator(DEFAULT_INITIAL_CONTENT_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_NONE).build();
    public static final ListAttributeDefinition WORKSPACES_INITIAL_CONTENT = MappedListAttributeDefinition.Builder.of("workspaces-initial-content", new MappedAttributeDefinitionBuilder("initial-content", ModelType.PROPERTY).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_NONE).setValidator(INITIAL_CONTENT_VALIDATOR).build()).setAllowNull(true).setMinSize(0).build();
    public static final ListAttributeDefinition NODE_TYPES = MappedListAttributeDefinition.Builder.of("node-types", new MappedAttributeDefinitionBuilder("node-type", ModelType.STRING).setAllowExpression(true).setAllowNull(false).setValidator(NODE_TYPE_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_NONE).build()).setAllowNull(true).setMinSize(0).build();
    public static final SimpleAttributeDefinition PROPERTY = new SimpleAttributeDefinition("property", ModelType.PROPERTY, true);
    public static final SimpleListAttributeDefinition PROPERTIES = SimpleListAttributeDefinition.Builder.of((String)"properties", (SimpleAttributeDefinition)PROPERTY).setAllowNull(true).build();
    public static final SimpleAttributeDefinition QUEUE_JNDI_NAME = new MappedAttributeDefinitionBuilder("queue-jndi-name", ModelType.STRING).setXmlName(Attribute.QUEUE_JNDI_NAME.getLocalName()).setAllowExpression(true).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition READER_STRATEGY = new MappedAttributeDefinitionBuilder("indexing-reader-strategy", ModelType.STRING).setXmlName(Attribute.READER_STRATEGY.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(RepositoryConfiguration.IndexReaderStrategy.SHARED.toString())).setValidator(READER_STRATEGY_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition REBUILD_INDEXES_UPON_STARTUP = new MappedAttributeDefinitionBuilder("rebuild-indexes-upon-startup", ModelType.STRING).setXmlName(Attribute.REBUILD_UPON_STARTUP.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(RepositoryConfiguration.QueryRebuild.IF_MISSING.toString())).setValidator(REBUILD_INDEXES_VALIDATOR).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("query", "rebuildUponStartup").build();
    public static final SimpleAttributeDefinition REFRESH_PERIOD = new MappedAttributeDefinitionBuilder("refresh-period", ModelType.INT).setXmlName(Attribute.REFRESH_PERIOD.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(3600)).setMeasurementUnit(MeasurementUnit.SECONDS).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("query", "indexStorage", "refreshInSeconds").build();
    public static final SimpleAttributeDefinition RELATIVE_TO = new MappedAttributeDefinitionBuilder("relative-to", ModelType.STRING).setXmlName(Attribute.RELATIVE_TO.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("jboss.server.data.dir")).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition RETRY_INITIALIZE_PERIOD = new MappedAttributeDefinitionBuilder("retry-initialize-period", ModelType.INT).setXmlName(Attribute.RETRY_INIT_PERIOD.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(0)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition RETRY_MARKER_LOOKUP = new MappedAttributeDefinitionBuilder("retry-marker-lookup", ModelType.INT).setXmlName(Attribute.RETRY_MARKER_LOOKUP.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(0)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition SEQUENCER_CLASSNAME = new MappedAttributeDefinitionBuilder("classname", ModelType.STRING).setXmlName(Attribute.CLASSNAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("sequencing", "sequencers", "classname").build();
    public static final SimpleAttributeDefinition TEXT_EXTRACTOR_CLASSNAME = new MappedAttributeDefinitionBuilder("classname", ModelType.STRING).setXmlName(Attribute.CLASSNAME.getLocalName()).setAllowExpression(false).setAllowNull(true).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("query", "textExtracting", "extractors", "classname").build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = new MappedAttributeDefinitionBuilder("security-domain", ModelType.STRING).setXmlName(Attribute.SECURITY_DOMAIN.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("modeshape-security")).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("security", "jaas", "policyName").build();
    public static final SimpleAttributeDefinition SOURCE_PATH = new MappedAttributeDefinitionBuilder("source-path", ModelType.STRING).setXmlName(Attribute.SOURCE_PATH.getLocalName()).setAllowExpression(true).setAllowNull(false).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition SOURCE_RELATIVE_TO = new MappedAttributeDefinitionBuilder("source-relative-to", ModelType.STRING).setXmlName(Attribute.SOURCE_RELATIVE_TO.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("jboss.server.data.dir")).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition THREAD_POOL = new MappedAttributeDefinitionBuilder("indexing-thread-pool", ModelType.STRING).setXmlName(Attribute.THREAD_POOL.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set("modeshape-workers")).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES).build();
    public static final SimpleAttributeDefinition USE_ANONYMOUS_IF_AUTH_FAILED = new MappedAttributeDefinitionBuilder("use-anonymous-upon-failed-authentication", ModelType.BOOLEAN).setXmlName(Attribute.USE_ANONYMOUS_IF_AUTH_FAILED.getLocalName()).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(false)).setFlags(AttributeAccess.Flag.RESTART_NONE).setFieldPathInRepositoryConfiguration("security", "anonymous", "useOnFailedLogin").build();
    public static final AttributeDefinition[] SUBSYSTEM_ATTRIBUTES = new AttributeDefinition[0];
    public static final AttributeDefinition[] REPOSITORY_ATTRIBUTES = new AttributeDefinition[]{CACHE_NAME, CACHE_CONTAINER, JNDI_NAME, ENABLE_MONITORING, SECURITY_DOMAIN, ANONYMOUS_ROLES, ANONYMOUS_USERNAME, USE_ANONYMOUS_IF_AUTH_FAILED, NODE_TYPES, DEFAULT_WORKSPACE, PREDEFINED_WORKSPACE_NAMES, ALLOW_WORKSPACE_CREATION, WORKSPACES_CACHE_CONTAINER, DEFAULT_INITIAL_CONTENT, WORKSPACES_INITIAL_CONTENT, MINIMUM_BINARY_SIZE, THREAD_POOL, BATCH_SIZE, READER_STRATEGY, MODE, SYSTEM_CONTENT_MODE, ASYNC_THREAD_POOL_SIZE, ASYNC_MAX_QUEUE_SIZE, ANALYZER_CLASSNAME, ANALYZER_MODULE, REBUILD_INDEXES_UPON_STARTUP, CLUSTER_NAME, CLUSTER_STACK};
    public static final AttributeDefinition[] RAM_INDEX_STORAGE_ATTRIBUTES = new AttributeDefinition[]{INDEX_STORAGE_TYPE};
    public static final AttributeDefinition[] LOCAL_FILE_INDEX_STORAGE_ATTRIBUTES = new AttributeDefinition[]{INDEX_STORAGE_TYPE, INDEX_FORMAT, PATH, RELATIVE_TO, ACCESS_TYPE, LOCKING_STRATEGY};
    public static final AttributeDefinition[] MASTER_FILE_INDEX_STORAGE_ATTRIBUTES = new AttributeDefinition[]{INDEX_STORAGE_TYPE, INDEX_FORMAT, PATH, RELATIVE_TO, ACCESS_TYPE, LOCKING_STRATEGY, REFRESH_PERIOD, SOURCE_PATH, SOURCE_RELATIVE_TO, CONNECTION_FACTORY_JNDI_NAME, QUEUE_JNDI_NAME};
    public static final AttributeDefinition[] SLAVE_FILE_INDEX_STORAGE_ATTRIBUTES = new AttributeDefinition[]{INDEX_STORAGE_TYPE, INDEX_FORMAT, PATH, RELATIVE_TO, ACCESS_TYPE, LOCKING_STRATEGY, REFRESH_PERIOD, SOURCE_PATH, SOURCE_RELATIVE_TO, CONNECTION_FACTORY_JNDI_NAME, QUEUE_JNDI_NAME, COPY_BUFFER_SIZE, RETRY_MARKER_LOOKUP, RETRY_INITIALIZE_PERIOD};
    public static final AttributeDefinition[] CACHE_INDEX_STORAGE_ATTRIBUTES = new AttributeDefinition[]{INDEX_STORAGE_TYPE, INDEX_FORMAT, DATA_CACHE_NAME, METADATA_CACHE_NAME, LOCK_CACHE_NAME, INDEX_STORAGE_CACHE_CONTAINER, CHUNK_SIZE};
    public static final AttributeDefinition[] CUSTOM_INDEX_STORAGE_ATTRIBUTES = new AttributeDefinition[]{INDEX_STORAGE_TYPE, INDEX_FORMAT, CLASSNAME, MODULE};
    public static final AttributeDefinition[] FILE_BINARY_STORAGE_ATTRIBUTES = new AttributeDefinition[]{BINARY_STORAGE_TYPE, MINIMUM_BINARY_SIZE, PATH, RELATIVE_TO};
    public static final AttributeDefinition[] CACHE_BINARY_STORAGE_ATTRIBUTES = new AttributeDefinition[]{BINARY_STORAGE_TYPE, MINIMUM_BINARY_SIZE, DATA_CACHE_NAME, METADATA_CACHE_NAME, CACHE_CONTAINER};
    public static final AttributeDefinition[] DATABASE_BINARY_STORAGE_ATTRIBUTES = new AttributeDefinition[]{BINARY_STORAGE_TYPE, MINIMUM_BINARY_SIZE, DATA_SOURCE_JNDI_NAME};
    public static final AttributeDefinition[] CUSTOM_BINARY_STORAGE_ATTRIBUTES = new AttributeDefinition[]{BINARY_STORAGE_TYPE, MINIMUM_BINARY_SIZE, CLASSNAME, MODULE};
    public static final AttributeDefinition[] SEQUENCER_ATTRIBUTES = new AttributeDefinition[]{PATH_EXPRESSIONS, SEQUENCER_CLASSNAME, MODULE, PROPERTIES};
    public static final AttributeDefinition[] TEXT_EXTRACTOR_ATTRIBUTES = new AttributeDefinition[]{TEXT_EXTRACTOR_CLASSNAME, MODULE, PROPERTIES};
}

